/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.packedinventory.api.v1.inventory;

import dev.kir.packedinventory.api.v1.FailureReason;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface InventoryViewer {
    public class_1263 view(class_1263 var1, int var2, class_1657 var3);

    @FunctionalInterface
    public static interface ExtendedValidator
    extends Validator {
        public static final ExtendedValidator EMPTY = (p, s, i, eI) -> null;

        @Override
        @Nullable
        default public FailureReason validate(class_1263 inventory, int slot, class_1657 player) {
            return this.validate(inventory, slot, player, inventory);
        }

        @Override
        default public ExtendedValidator and(Validator other) {
            return (ExtendedValidator)Validator.super.and(other);
        }

        @Override
        default public ExtendedValidator or(Validator other) {
            return (ExtendedValidator)Validator.super.or(other);
        }

        @Nullable
        public FailureReason validate(class_1263 var1, int var2, class_1657 var3, class_1263 var4);
    }

    @FunctionalInterface
    public static interface Validator {
        public static final Validator EMPTY = (i, s, p) -> null;

        @Nullable
        public FailureReason validate(class_1263 var1, int var2, class_1657 var3);

        default public Validator and(Validator other) {
            Validator it = this;
            if (this instanceof ExtendedValidator || other instanceof ExtendedValidator) {
                return (i, s, p, eI) -> {
                    FailureReason reason;
                    FailureReason failureReason = reason = it instanceof ExtendedValidator ? ((ExtendedValidator)it).validate(i, s, p, eI) : it.validate(i, s, p);
                    if (reason != null) {
                        return reason;
                    }
                    return other instanceof ExtendedValidator ? ((ExtendedValidator)other).validate(i, s, p, eI) : other.validate(i, s, p);
                };
            }
            return (i, s, p) -> {
                FailureReason reason = it.validate(i, s, p);
                return reason == null ? other.validate(i, s, p) : reason;
            };
        }

        default public Validator or(Validator other) {
            Validator it = this;
            if (this instanceof ExtendedValidator || other instanceof ExtendedValidator) {
                return (i, s, p, eI) -> {
                    FailureReason reason;
                    FailureReason failureReason = reason = it instanceof ExtendedValidator ? ((ExtendedValidator)it).validate(i, s, p, eI) : it.validate(i, s, p);
                    if (reason == null) {
                        return null;
                    }
                    return other instanceof ExtendedValidator ? ((ExtendedValidator)other).validate(i, s, p, eI) : other.validate(i, s, p);
                };
            }
            return (i, s, p) -> {
                FailureReason reason = it.validate(i, s, p);
                return reason == null ? null : other.validate(i, s, p);
            };
        }
    }

    @FunctionalInterface
    public static interface ItemPredicate
    extends Predicate {
        public Set<class_1792> getItems();

        @Override
        default public boolean test(class_1263 inventory, int slot, class_1657 player) {
            return this.getItems().contains(inventory.method_5438(slot).method_7909());
        }

        @Override
        default public ItemPredicate and(Predicate other) {
            return (ItemPredicate)Predicate.super.and(other);
        }

        @Override
        default public ItemPredicate or(Predicate other) {
            return (ItemPredicate)Predicate.super.or(other);
        }

        public static ItemPredicate of(Collection<class_1792> items) {
            return ItemPredicate.of(items, null);
        }

        public static ItemPredicate of(Collection<class_1792> items, final @Nullable Predicate innerPredicate) {
            final Set<class_1792> itemSet = Set.copyOf(items);
            if (innerPredicate == null) {
                return () -> itemSet;
            }
            return new ItemPredicate(){

                @Override
                public Set<class_1792> getItems() {
                    return itemSet;
                }

                @Override
                public boolean test(class_1263 inventory, int slot, class_1657 player) {
                    return innerPredicate.test(inventory, slot, player);
                }
            };
        }
    }

    @FunctionalInterface
    public static interface Predicate {
        public static final Predicate TRUE = (i, s, p) -> true;
        public static final Predicate FALSE = (i, s, p) -> false;

        public boolean test(class_1263 var1, int var2, class_1657 var3);

        default public Predicate and(final Predicate other) {
            Set<class_1792> items = null;
            if (this instanceof ItemPredicate) {
                items = ((ItemPredicate)this).getItems();
            }
            if (other instanceof ItemPredicate) {
                if (items == null) {
                    items = ((ItemPredicate)other).getItems();
                } else {
                    items = new HashSet<class_1792>(items);
                    items.retainAll(((ItemPredicate)other).getItems());
                    items = Set.copyOf(items);
                }
            }
            final Predicate it = this;
            if (items != null) {
                final Set<class_1792> finalItems = items;
                return new ItemPredicate(){

                    @Override
                    public Set<class_1792> getItems() {
                        return finalItems;
                    }

                    @Override
                    public boolean test(class_1263 inventory, int slot, class_1657 player) {
                        return it.test(inventory, slot, player) && other.test(inventory, slot, player);
                    }
                };
            }
            return (i, s, p) -> it.test(i, s, p) && other.test(i, s, p);
        }

        default public Predicate or(final Predicate other) {
            Set<class_1792> items = null;
            if (this instanceof ItemPredicate) {
                items = ((ItemPredicate)this).getItems();
            }
            if (other instanceof ItemPredicate) {
                if (items == null) {
                    items = ((ItemPredicate)other).getItems();
                } else {
                    items = new HashSet<class_1792>(items);
                    items.addAll(((ItemPredicate)other).getItems());
                    items = Set.copyOf(items);
                }
            }
            final Predicate it = this;
            if (items != null) {
                final Set<class_1792> finalItems = items;
                return new ItemPredicate(){

                    @Override
                    public Set<class_1792> getItems() {
                        return finalItems;
                    }

                    @Override
                    public boolean test(class_1263 inventory, int slot, class_1657 player) {
                        return it.test(inventory, slot, player) || other.test(inventory, slot, player);
                    }
                };
            }
            return (p, i, s) -> it.test(p, i, s) || other.test(p, i, s);
        }
    }
}

