/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.packedinventory.api.v1.inventory;

import com.mojang.datafixers.util.Either;
import dev.kir.packedinventory.api.v1.FailureReason;
import dev.kir.packedinventory.api.v1.inventory.InventoryViewer;
import dev.kir.packedinventory.api.v1.inventory.InventoryViewerRegistryImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import org.jetbrains.annotations.ApiStatus;

public interface InventoryViewerRegistry {
    @ApiStatus.Internal
    public static InventoryViewerRegistry getInstance() {
        return InventoryViewerRegistryImpl.INSTANCE;
    }

    default public boolean hasView(class_1263 inventory, int slot, class_1657 player) {
        return this.forceView(inventory, slot, player).isPresent();
    }

    public Optional<class_1263> forceView(class_1263 var1, int var2, class_1657 var3);

    public Optional<Either<class_1263, FailureReason>> view(class_1263 var1, int var2, class_1657 var3);

    public Entry register(Entry var1);

    default public Entry register(final InventoryViewer viewer, final InventoryViewer.Validator validator, final InventoryViewer.Predicate predicate) {
        return this.register(new Entry(){

            @Override
            public InventoryViewer getInventoryViewer() {
                return viewer;
            }

            @Override
            public InventoryViewer.Validator getValidator() {
                return validator;
            }

            @Override
            public InventoryViewer.Predicate getPredicate() {
                return predicate;
            }
        });
    }

    default public Entry register(InventoryViewer viewer, InventoryViewer.Validator validator, class_1792 item) {
        return this.register(viewer, validator, List.of(item));
    }

    default public Entry register(InventoryViewer viewer, InventoryViewer.Validator validator, class_1792 ... items) {
        return this.register(viewer, validator, Arrays.asList(items));
    }

    default public Entry register(InventoryViewer viewer, InventoryViewer.Validator validator, Collection<class_1792> items) {
        return this.register(viewer, validator, (InventoryViewer.Predicate)InventoryViewer.ItemPredicate.of(items));
    }

    default public Entry register(InventoryViewer viewer, InventoryViewer.ExtendedValidator validator, InventoryViewer.Predicate predicate) {
        return this.register(viewer, (InventoryViewer.Validator)validator, predicate);
    }

    default public Entry register(InventoryViewer viewer, InventoryViewer.ExtendedValidator validator, class_1792 item) {
        return this.register(viewer, (InventoryViewer.Validator)validator, item);
    }

    default public Entry register(InventoryViewer viewer, InventoryViewer.ExtendedValidator validator, class_1792 ... items) {
        return this.register(viewer, (InventoryViewer.Validator)validator, items);
    }

    default public Entry register(InventoryViewer viewer, InventoryViewer.ExtendedValidator validator, Collection<class_1792> items) {
        return this.register(viewer, (InventoryViewer.Validator)validator, items);
    }

    default public Entry register(InventoryViewer viewer, InventoryViewer.Predicate predicate) {
        return this.register(viewer, InventoryViewer.Validator.EMPTY, predicate);
    }

    default public Entry register(InventoryViewer viewer, class_1792 item) {
        return this.register(viewer, InventoryViewer.Validator.EMPTY, item);
    }

    default public Entry register(InventoryViewer viewer, class_1792 ... items) {
        return this.register(viewer, InventoryViewer.Validator.EMPTY, items);
    }

    default public Entry register(InventoryViewer viewer, Collection<class_1792> items) {
        return this.register(viewer, InventoryViewer.Validator.EMPTY, items);
    }

    public boolean unregister(InventoryViewer var1);

    default public boolean unregister(Entry entry) {
        return this.unregister(entry.getInventoryViewer());
    }

    public static interface Entry {
        public InventoryViewer getInventoryViewer();

        public InventoryViewer.Predicate getPredicate();

        public InventoryViewer.Validator getValidator();
    }
}

