/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.packedinventory.api.v1.inventory;

import com.mojang.datafixers.util.Either;
import dev.kir.packedinventory.api.v1.FailureReason;
import dev.kir.packedinventory.api.v1.inventory.InventoryViewer;
import dev.kir.packedinventory.api.v1.inventory.InventoryViewerRegistry;
import dev.kir.packedinventory.inventory.CombinedInventory;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_3545;
import org.jetbrains.annotations.Nullable;

final class InventoryViewerRegistryImpl
implements InventoryViewerRegistry {
    public static final InventoryViewerRegistryImpl INSTANCE = new InventoryViewerRegistryImpl();
    private final Map<class_1792, InventoryViewerRegistry.Entry> itemBasedInventoryViewers = new HashMap<class_1792, InventoryViewerRegistry.Entry>();
    private final Set<InventoryViewerRegistry.Entry> genericInventoryViewersSet = new HashSet<InventoryViewerRegistry.Entry>();
    private final Deque<InventoryViewerRegistry.Entry> genericInventoryViewers = new ArrayDeque<InventoryViewerRegistry.Entry>();

    InventoryViewerRegistryImpl() {
    }

    @Override
    public Optional<class_1263> forceView(class_1263 inventory, int slot, class_1657 player) {
        InventoryViewerRegistry.Entry entry = this.findViewerEntry(inventory, slot, player);
        if (entry == null) {
            return Optional.empty();
        }
        return Optional.of(entry.getInventoryViewer().view(inventory, slot, player));
    }

    @Override
    public boolean hasView(class_1263 inventory, int slot, class_1657 player) {
        return this.findViewerEntry(inventory, slot, player) != null;
    }

    @Override
    public Optional<Either<class_1263, FailureReason>> view(class_1263 inventory, int slot, class_1657 player) {
        InventoryViewerRegistry.Entry entry = this.findViewerEntry(inventory, slot, player);
        if (entry == null) {
            return Optional.empty();
        }
        FailureReason reason = entry.getValidator().validate(inventory, slot, player);
        if (reason != null && entry.getValidator() instanceof InventoryViewer.ExtendedValidator) {
            boolean wasAdded;
            class_1263 extendedInventory;
            ArrayList<class_3545> innerViewers = new ArrayList<class_3545>();
            ArrayList<class_1263> inventories = new ArrayList<class_1263>();
            inventories.add(inventory);
            if (player.method_31548() != inventory) {
                inventories.add((class_1263)player.method_31548());
            }
            for (int i = 0; i < inventory.method_5439(); ++i) {
                InventoryViewerRegistry.Entry innerEntry;
                if (i == slot || (innerEntry = this.findViewerEntry(inventory, i, player)) == null) continue;
                if (innerEntry.getValidator().validate(inventory, slot, player) == null) {
                    inventories.add(innerEntry.getInventoryViewer().view(inventory, i, player));
                    continue;
                }
                if (!(innerEntry.getValidator() instanceof InventoryViewer.ExtendedValidator)) continue;
                innerViewers.add(new class_3545((Object)innerEntry, (Object)i));
            }
            InventoryViewer.ExtendedValidator extendedValidator = (InventoryViewer.ExtendedValidator)entry.getValidator();
            while ((reason = extendedValidator.validate(inventory, slot, player, extendedInventory = CombinedInventory.of(inventories))) != null && (wasAdded = innerViewers.removeIf(x -> {
                if (((InventoryViewer.ExtendedValidator)((InventoryViewerRegistry.Entry)x.method_15442()).getValidator()).validate(inventory, (Integer)x.method_15441(), player, extendedInventory) == null) {
                    inventories.add(((InventoryViewerRegistry.Entry)x.method_15442()).getInventoryViewer().view(inventory, (Integer)x.method_15441(), player));
                    return true;
                }
                return false;
            }))) {
            }
        }
        if (reason != null) {
            return Optional.of(Either.right((Object)reason));
        }
        return Optional.of(Either.left((Object)entry.getInventoryViewer().view(inventory, slot, player)));
    }

    @Nullable
    private InventoryViewerRegistry.Entry findViewerEntry(class_1263 inventory, int slot, class_1657 player) {
        InventoryViewerRegistry.Entry entry = this.itemBasedInventoryViewers.get(inventory.method_5438(slot).method_7909());
        if (entry != null && entry.getPredicate().test(inventory, slot, player)) {
            return entry;
        }
        for (InventoryViewerRegistry.Entry genericEntry : this.genericInventoryViewers) {
            if (!genericEntry.getPredicate().test(inventory, slot, player)) continue;
            return genericEntry;
        }
        return null;
    }

    @Override
    public InventoryViewerRegistry.Entry register(InventoryViewerRegistry.Entry entry) {
        if (entry.getPredicate() instanceof InventoryViewer.ItemPredicate) {
            for (class_1792 item : ((InventoryViewer.ItemPredicate)entry.getPredicate()).getItems()) {
                this.itemBasedInventoryViewers.put(item, entry);
            }
        } else if (this.genericInventoryViewersSet.add(entry)) {
            this.genericInventoryViewers.push(entry);
        }
        return entry;
    }

    @Override
    public InventoryViewerRegistry.Entry register(InventoryViewer viewer, InventoryViewer.Validator validator, Collection<class_1792> items) {
        return this.register(viewer, validator, (InventoryViewer.Predicate)InventoryViewer.ItemPredicate.of(items, InventoryViewer.Predicate.TRUE));
    }

    @Override
    public boolean unregister(InventoryViewer viewer) {
        return this.itemBasedInventoryViewers.entrySet().removeIf(x -> ((InventoryViewerRegistry.Entry)x.getValue()).getInventoryViewer() == viewer) | this.genericInventoryViewersSet.removeIf(x -> x.getInventoryViewer() == viewer) && this.genericInventoryViewers.removeIf(x -> x.getInventoryViewer() == viewer);
    }
}

