/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.packedinventory.api.v1.item;

import dev.kir.packedinventory.api.v1.item.TooltipSyncData;
import dev.kir.packedinventory.inventory.EmptyInventory;
import dev.kir.packedinventory.inventory.ListInventory;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class GenericContainerTooltipSyncData
implements TooltipSyncData {
    private class_1263 inventory;

    protected GenericContainerTooltipSyncData() {
        this(EmptyInventory.getInstance());
    }

    protected GenericContainerTooltipSyncData(class_1263 inventory) {
        this.inventory = inventory;
    }

    public class_1263 getInventory() {
        return this.inventory;
    }

    public static GenericContainerTooltipSyncData of() {
        return new GenericContainerTooltipSyncData();
    }

    public static GenericContainerTooltipSyncData of(class_1263 inventory) {
        return new GenericContainerTooltipSyncData(inventory);
    }

    public static GenericContainerTooltipSyncData of(class_2371<class_1799> inventory) {
        return new GenericContainerTooltipSyncData(ListInventory.wrap(inventory));
    }

    public static GenericContainerTooltipSyncData ofSize(int size) {
        return new GenericContainerTooltipSyncData(ListInventory.wrap((class_2371<class_1799>)class_2371.method_10213((int)size, (Object)class_1799.field_8037)));
    }

    @Override
    public void readNbt(class_2487 nbt) {
        int size = nbt.method_10550("Size");
        if (size == 0) {
            this.inventory = EmptyInventory.getInstance();
            return;
        }
        class_2371 inventory = class_2371.method_10213((int)size, (Object)class_1799.field_8037);
        class_2499 items = nbt.method_10554("Items", 10);
        for (class_2520 item : items) {
            int slot;
            if (!(item instanceof class_2487) || (slot = ((class_2487)item).method_10571("Slot") & 0xFF) >= size) continue;
            inventory.set(slot, (Object)class_1799.method_7915((class_2487)((class_2487)item)));
        }
        this.inventory = ListInventory.wrap((class_2371<class_1799>)inventory);
    }

    @Override
    public void writeNbt(class_2487 nbt) {
        class_1263 inventory = this.inventory;
        int size = inventory.method_5439();
        nbt.method_10569("Size", size);
        if (size == 0) {
            return;
        }
        class_2499 items = new class_2499();
        for (int i = 0; i < size; ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7960()) continue;
            class_2487 stackNbt = new class_2487();
            stack.method_7953(stackNbt);
            stackNbt.method_10567("Slot", (byte)i);
            items.add((Object)stackNbt);
        }
        nbt.method_10566("Items", (class_2520)items);
    }
}

