/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.packedinventory.api.v1.item;

import dev.kir.packedinventory.api.v1.item.SyncedTooltipProvider;
import dev.kir.packedinventory.api.v1.item.TooltipProvider;
import dev.kir.packedinventory.api.v1.item.TooltipProviderContext;
import dev.kir.packedinventory.api.v1.item.TooltipProviderRegistry;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_5632;
import org.jetbrains.annotations.Nullable;

final class TooltipProviderRegistryImpl
implements TooltipProviderRegistry {
    public static final TooltipProviderRegistryImpl INSTANCE = new TooltipProviderRegistryImpl();
    private final Map<class_1792, TooltipProviderRegistry.Entry> itemBasedProviders = new HashMap<class_1792, TooltipProviderRegistry.Entry>();
    private final Set<TooltipProviderRegistry.Entry> genericProvidersSet = new HashSet<TooltipProviderRegistry.Entry>();
    private final Deque<TooltipProviderRegistry.Entry> genericProviders = new ArrayDeque<TooltipProviderRegistry.Entry>();
    @Nullable
    private TooltipProviderRegistry.Entry defaultProvider = null;

    TooltipProviderRegistryImpl() {
    }

    @Override
    public Optional<Optional<class_5632>> getTooltipData(class_1799 stack, TooltipProviderContext context) {
        TooltipProviderRegistry.Entry providerEntry = this.findProvider(stack, context);
        if (providerEntry == null) {
            return Optional.empty();
        }
        return Optional.of(providerEntry.getProvider().getTooltipData(stack, context));
    }

    @Override
    public Optional<List<class_2561>> getTooltipText(class_1799 stack, TooltipProviderContext context) {
        TooltipProviderRegistry.Entry providerEntry = this.findProvider(stack, context);
        if (providerEntry == null) {
            return Optional.empty();
        }
        return Optional.of(providerEntry.getProvider().getTooltipText(stack, context));
    }

    @Override
    public boolean updateTooltipSyncData(class_1799 stack, TooltipProviderContext context, class_2487 nbt) {
        TooltipProviderRegistry.Entry providerEntry = this.findProvider(stack, context);
        if (providerEntry == null || !(providerEntry.getProvider() instanceof SyncedTooltipProvider)) {
            return false;
        }
        ((SyncedTooltipProvider)providerEntry.getProvider()).readTooltipSyncDataNbt(stack, context, nbt);
        return true;
    }

    @Nullable
    private TooltipProviderRegistry.Entry findProvider(class_1799 stack, TooltipProviderContext context) {
        TooltipProviderRegistry.Entry entry = this.itemBasedProviders.get(stack.method_7909());
        if (entry != null && entry.getPredicate().test(stack, context)) {
            return entry;
        }
        for (TooltipProviderRegistry.Entry genericEntry : this.genericProviders) {
            if (!genericEntry.getPredicate().test(stack, context)) continue;
            return genericEntry;
        }
        return this.defaultProvider;
    }

    @Override
    public TooltipProviderRegistry.Entry register(TooltipProviderRegistry.Entry entry) {
        if (entry.getPredicate() instanceof TooltipProvider.ItemPredicate) {
            for (class_1792 item : ((TooltipProvider.ItemPredicate)entry.getPredicate()).getItems()) {
                this.itemBasedProviders.put(item, entry);
            }
        } else if (this.genericProvidersSet.add(entry)) {
            this.genericProviders.push(entry);
        }
        return entry;
    }

    @Override
    public TooltipProviderRegistry.Entry register(TooltipProvider provider, Collection<class_1792> items) {
        return this.register(provider, TooltipProvider.ItemPredicate.of(items, TooltipProvider.Predicate.TRUE));
    }

    @Override
    public TooltipProviderRegistry.Entry registerDefault(final TooltipProvider provider) {
        this.defaultProvider = new TooltipProviderRegistry.Entry(){

            @Override
            public TooltipProvider getProvider() {
                return provider;
            }

            @Override
            public TooltipProvider.Predicate getPredicate() {
                return TooltipProvider.Predicate.TRUE;
            }
        };
        return this.defaultProvider;
    }

    @Override
    public boolean unregister(TooltipProvider provider) {
        boolean removed = this.itemBasedProviders.entrySet().removeIf(x -> ((TooltipProviderRegistry.Entry)x.getValue()).getProvider() == provider);
        removed |= this.genericProvidersSet.removeIf(x -> x.getProvider() == provider) && this.genericProviders.removeIf(x -> x.getProvider() == provider);
        if (this.defaultProvider != null && this.defaultProvider.getProvider() == provider) {
            this.defaultProvider = null;
            removed = true;
        }
        return removed;
    }
}

