/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.packedinventory.api.v1.networking;

import dev.kir.packedinventory.PackedInventory;
import dev.kir.packedinventory.api.v1.item.TooltipProviderContext;
import dev.kir.packedinventory.api.v1.item.TooltipProviderRegistry;
import dev.kir.packedinventory.api.v1.item.TooltipSyncDataProviderRegistry;
import java.util.function.BiFunction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_634;
import net.minecraft.server.MinecraftServer;

public final class TooltipSyncRequest {
    public static final class_2960 ID = PackedInventory.locate("tooltip_sync_request");

    @Environment(value=EnvType.CLIENT)
    public static void sendToServer(class_1799 stack) {
        if (!ClientPlayNetworking.canSend((class_2960)ID)) {
            return;
        }
        class_2540 buffer = PacketByteBufs.create();
        buffer.method_10793(stack);
        ClientPlayNetworking.send((class_2960)ID, (class_2540)buffer);
    }

    private static void sendToClient(class_3222 player, class_1799 stack, class_2487 syncData) {
        class_2540 buffer = PacketByteBufs.create();
        buffer.method_10793(stack);
        buffer.method_10794(syncData);
        ServerPlayNetworking.send((class_3222)player, (class_2960)ID, (class_2540)buffer);
    }

    private static void executeServer(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        class_1799 stack = buf.method_10819();
        TooltipSyncDataProviderRegistry.getInstance().getTooltipSyncData(stack, (class_1657)player).ifPresent(x -> {
            class_2487 nbt = new class_2487();
            x.writeNbt(nbt);
            TooltipSyncRequest.sendToClient(player, stack, nbt);
        });
    }

    @Environment(value=EnvType.CLIENT)
    private static void executeClient(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        class_1799 stack = buf.method_10819();
        class_2487 nbt = buf.method_30617();
        client.execute(() -> TooltipProviderRegistry.getInstance().updateTooltipSyncData(stack, TooltipProviderContext.of(), nbt));
    }

    public static void registerServerReceiver(BiFunction<class_2960, ServerPlayNetworking.PlayChannelHandler, Boolean> receiver) {
        receiver.apply(ID, TooltipSyncRequest::executeServer);
    }

    @Environment(value=EnvType.CLIENT)
    public static void registerClientReceiver(BiFunction<class_2960, ClientPlayNetworking.PlayChannelHandler, Boolean> receiver) {
        receiver.apply(ID, TooltipSyncRequest::executeClient);
    }

    private TooltipSyncRequest() {
    }
}

