/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.packedinventory.client.item;

import dev.kir.packedinventory.api.v1.config.GenericSyncedTooltipConfig;
import dev.kir.packedinventory.api.v1.config.GenericTooltipConfig;
import dev.kir.packedinventory.api.v1.config.PackedInventoryApiConfig;
import dev.kir.packedinventory.api.v1.item.GenericContainerTooltipData;
import dev.kir.packedinventory.api.v1.item.GenericContainerTooltipSyncData;
import dev.kir.packedinventory.api.v1.item.ItemStackComponentStorage;
import dev.kir.packedinventory.api.v1.item.TooltipProvider;
import dev.kir.packedinventory.api.v1.item.TooltipProviderRegistry;
import dev.kir.packedinventory.api.v1.item.TooltipText;
import dev.kir.packedinventory.config.FilledMapTooltipConfig;
import dev.kir.packedinventory.inventory.ListInventory;
import dev.kir.packedinventory.item.FilledMapTooltipData;
import dev.kir.packedinventory.util.inventory.InventoryUtil;
import dev.kir.packedinventory.util.item.ItemUtil;
import java.util.Arrays;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1263;
import net.minecraft.class_1767;
import net.minecraft.class_1802;
import net.minecraft.class_2248;
import net.minecraft.class_2480;

@Environment(value=EnvType.CLIENT)
public final class PackedInventoryTooltipProviders {
    private static TooltipProviderRegistry.Entry SHULKER_BOX;
    private static TooltipProviderRegistry.Entry ENDER_CHEST;
    private static TooltipProviderRegistry.Entry FILLED_MAP;
    private static TooltipProviderRegistry.Entry DEFAULT;

    public static TooltipProviderRegistry.Entry getShulkerBox() {
        return SHULKER_BOX;
    }

    public static TooltipProviderRegistry.Entry getEnderChest() {
        return ENDER_CHEST;
    }

    public static TooltipProviderRegistry.Entry getFilledMap() {
        return FILLED_MAP;
    }

    public static TooltipProviderRegistry.Entry getDefault() {
        return DEFAULT;
    }

    public static void initClient(TooltipProviderRegistry registry, PackedInventoryApiConfig config) {
        SHULKER_BOX = PackedInventoryTooltipProviders.registerShulkerBox(registry, config);
        ENDER_CHEST = PackedInventoryTooltipProviders.registerEnderChest(registry, config);
        FILLED_MAP = PackedInventoryTooltipProviders.registerFilledMap(registry, config);
        DEFAULT = PackedInventoryTooltipProviders.registerDefault(registry, config);
    }

    private static TooltipProviderRegistry.Entry registerShulkerBox(TooltipProviderRegistry registry, PackedInventoryApiConfig config) {
        config.registerTooltipConfig(class_1802.field_8545, GenericTooltipConfig::new);
        return registry.register(TooltipProvider.builder().when((s, c) -> config.getTooltipConfigOrDefault(class_1802.field_8545).isEnabled()).modifyTooltipText((text, stack, context) -> text.clear(TooltipText.Part.ADDITIONAL)).tooltipData((stack, context) -> {
            class_1767 color;
            GenericTooltipConfig cfg = config.getTooltipConfigOrDefault(class_1802.field_8545);
            class_1263 inventory = ListInventory.wrap(cfg.isCompact() ? InventoryUtil.zip(InventoryUtil.getInventory(stack)) : InventoryUtil.getInventory(stack));
            if (!cfg.shouldShowWhenEmpty() && inventory.method_5442()) {
                return null;
            }
            class_1767 class_17672 = color = cfg.usePredefinedColor() ? ItemUtil.getColor(stack) : null;
            if (color == null) {
                color = cfg.color();
            }
            return GenericContainerTooltipData.of(inventory, cfg.rows(), cfg.columns(), color);
        }).build(), Stream.concat(Arrays.stream(class_1767.values()), Stream.of((class_1767)null)).map(class_2480::method_10525).map(class_2248::method_8389).toList());
    }

    private static TooltipProviderRegistry.Entry registerEnderChest(TooltipProviderRegistry registry, PackedInventoryApiConfig config) {
        config.registerTooltipConfig(class_1802.field_8466, GenericSyncedTooltipConfig::new);
        return registry.register((TooltipProvider)TooltipProvider.builder().when((s, c) -> config.getTooltipConfigOrDefault(class_1802.field_8466).isEnabled()).useSyncData(GenericContainerTooltipSyncData::of, ItemStackComponentStorage.singleton(class_1802.field_8466)).tooltipData((stack, context, data) -> {
            class_1767 color;
            class_1263 inventory;
            GenericTooltipConfig cfg = config.getTooltipConfigOrDefault(class_1802.field_8466);
            class_1263 class_12632 = inventory = cfg.isCompact() ? InventoryUtil.zip(data.getInventory()) : data.getInventory();
            if (!cfg.shouldShowWhenEmpty() && inventory.method_5442()) {
                return null;
            }
            class_1767 class_17672 = color = cfg.usePredefinedColor() ? ItemUtil.getColor(stack) : null;
            if (color == null) {
                color = cfg.color();
            }
            return GenericContainerTooltipData.of(inventory, cfg.rows(), cfg.columns(), color);
        }).syncInterval(s -> config.getTooltipConfigOrDefault(class_1802.field_8466, GenericSyncedTooltipConfig.DEFAULT).syncInterval()).build(), class_1802.field_8466);
    }

    private static TooltipProviderRegistry.Entry registerFilledMap(TooltipProviderRegistry registry, PackedInventoryApiConfig config) {
        config.registerTooltipConfig(class_1802.field_8204, FilledMapTooltipConfig::new);
        return registry.register(TooltipProvider.builder().when((s, c) -> config.getTooltipConfigOrDefault(class_1802.field_8204, FilledMapTooltipConfig.DEFAULT).isEnabled()).tooltipData((stack, context) -> {
            if (context.getPlayer() == null) {
                return null;
            }
            FilledMapTooltipConfig cfg = config.getTooltipConfigOrDefault(class_1802.field_8204, FilledMapTooltipConfig.DEFAULT);
            return new FilledMapTooltipData(stack, context.getPlayer().method_37908(), cfg.isCompact(), cfg.size());
        }).build(), class_1802.field_8204);
    }

    private static TooltipProviderRegistry.Entry registerDefault(TooltipProviderRegistry registry, PackedInventoryApiConfig config) {
        return registry.registerDefault(TooltipProvider.builder().when((s, c) -> ItemUtil.isInventory(s) && config.getTooltipConfigOrDefault(s.method_7909()).isEnabled()).modifyTooltipText((text, stack, context) -> text.clear(TooltipText.Part.LORE)).tooltipData((stack, context) -> {
            class_1767 color;
            GenericTooltipConfig cfg = config.getTooltipConfigOrDefault(stack.method_7909());
            class_1263 inventory = ListInventory.wrap(cfg.isCompact() ? InventoryUtil.zip(InventoryUtil.getInventory(stack)) : InventoryUtil.getInventory(stack));
            if (!cfg.shouldShowWhenEmpty() && inventory.method_5442()) {
                return null;
            }
            class_1767 class_17672 = color = cfg.usePredefinedColor() ? ItemUtil.getColor(stack) : null;
            if (color == null) {
                color = cfg.color();
            }
            return GenericContainerTooltipData.of(inventory, cfg.rows(), cfg.columns(), color);
        }).build());
    }

    private PackedInventoryTooltipProviders() {
    }
}

