/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.packedinventory.compat.cloth;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import dev.kir.packedinventory.api.v1.config.GenericTooltipConfig;
import dev.kir.packedinventory.api.v1.config.GenericValidationConfig;
import dev.kir.packedinventory.api.v1.config.PackedInventoryApiConfig;
import dev.kir.packedinventory.api.v1.config.PackedInventoryConfigEntryHolder;
import dev.kir.packedinventory.config.PackedInventoryConfig;
import dev.kir.packedinventory.util.collection.DefaultedMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import me.shedaniel.autoconfig.util.Utils;
import net.minecraft.class_1269;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

@Config(name="packed-inventory")
public class PackedInventoryClothConfig
implements PackedInventoryConfig,
ConfigData {
    @ConfigEntry.Category(value="tooltips")
    private static final PackedInventoryClothConfig INSTANCE = (PackedInventoryClothConfig)AutoConfig.register(PackedInventoryClothConfig.class, GsonConfigSerializer::new).getConfig();
    @ConfigEntry.Category(value="tooltips")
    @ConfigEntry.Gui.CollapsibleObject
    protected GenericTooltipConfig defaultTooltipConfig = new GenericTooltipConfig();
    @ConfigEntry.Category(value="tooltips")
    @ConfigEntry.Gui.Excluded
    protected transient Map<class_2960, PackedInventoryConfigEntryHolder<?>> tooltipEntries = new LinkedHashMap();
    @ConfigEntry.Category(value="tooltips")
    @ConfigEntry.Gui.Excluded
    protected Map<String, JsonElement> tooltips = new LinkedHashMap<String, JsonElement>();
    @ConfigEntry.Category(value="tooltips")
    protected transient DefaultedMap<class_2960, Object> tooltipData = DefaultedMap.wrap(new LinkedHashMap(), () -> new class_2960("item"), GenericTooltipConfig::new);
    @ConfigEntry.Category(value="validation")
    @ConfigEntry.Gui.CollapsibleObject
    protected GenericValidationConfig defaultValidationConfig = new GenericValidationConfig();
    @ConfigEntry.Category(value="validation")
    @ConfigEntry.Gui.Excluded
    protected transient Map<class_2960, PackedInventoryConfigEntryHolder<?>> validationEntries = new LinkedHashMap();
    @ConfigEntry.Category(value="validation")
    @ConfigEntry.Gui.Excluded
    protected Map<String, JsonElement> validation = new LinkedHashMap<String, JsonElement>();
    @ConfigEntry.Category(value="validation")
    protected transient DefaultedMap<class_2960, Object> validationData = DefaultedMap.wrap(new LinkedHashMap(), () -> new class_2960("item"), GenericValidationConfig::new);
    @ConfigEntry.Category(value="validation")
    @ConfigEntry.Gui.Excluded
    private final transient Map<PackedInventoryApiConfig.ConfigSection, ConfigSectionData> configSections = Map.of(PackedInventoryApiConfig.ConfigSection.TOOLTIPS, new ConfigSectionData(() -> this.tooltips, () -> this.tooltipEntries, () -> this.tooltipData), PackedInventoryApiConfig.ConfigSection.VALIDATION, new ConfigSectionData(() -> this.validation, () -> this.validationEntries, () -> this.validationData));

    private PackedInventoryClothConfig() {
    }

    public static PackedInventoryConfig getInstance() {
        return INSTANCE;
    }

    @Override
    public GenericValidationConfig getDefaultValidationConfig() {
        return this.defaultValidationConfig;
    }

    @Override
    public GenericTooltipConfig getDefaultTooltipConfig() {
        return this.defaultTooltipConfig;
    }

    @Override
    @Nullable
    public <T> T get(class_2960 id, PackedInventoryApiConfig.ConfigSection section, Class<? extends T> entryClass) {
        ConfigSectionData configSectionData = this.configSections.get((Object)section);
        if (configSectionData == null) {
            return null;
        }
        Object entry = configSectionData.getValues().get(id);
        if (entry == null && !configSectionData.getEntries().containsKey(id) && configSectionData.getSerializedValues().containsKey(id.toString())) {
            this.register(id, section, PackedInventoryConfigEntryHolder.gson(() -> Utils.constructUnsafely((Class)entryClass)));
            entry = configSectionData.getValues().get(id);
        }
        if (entryClass.isInstance(entry)) {
            return (T)entry;
        }
        return null;
    }

    @Override
    public <T> void register(class_2960 id, PackedInventoryApiConfig.ConfigSection section, PackedInventoryConfigEntryHolder<T> configEntryHolder) {
        ConfigSectionData configSectionData = this.configSections.get((Object)section);
        if (configSectionData == null) {
            return;
        }
        configSectionData.getEntries().put(id, configEntryHolder);
        JsonElement serializedValue = configSectionData.getSerializedValues().get(id.toString());
        if (serializedValue != null) {
            configEntryHolder.fromJson(serializedValue.toString());
        }
        configSectionData.getValues().put(id, configEntryHolder.getConfigEntry());
    }

    private void onSave() {
        for (PackedInventoryApiConfig.ConfigSection section : PackedInventoryApiConfig.ConfigSection.values()) {
            ConfigSectionData configSectionData = this.configSections.get((Object)section);
            if (configSectionData == null) continue;
            configSectionData.getSerializedValues().clear();
            for (Map.Entry entry : configSectionData.getValues().entrySet()) {
                PackedInventoryConfigEntryHolder<Object> configHolder = configSectionData.getEntries().get(entry.getKey());
                if (configHolder == null && entry.getValue() != null) {
                    configHolder = PackedInventoryConfigEntryHolder.gson(entry::getValue);
                }
                if (configHolder == null) continue;
                configHolder.setConfigEntry(entry.getValue());
                configSectionData.getSerializedValues().put(((class_2960)entry.getKey()).toString(), JsonParser.parseString((String)configHolder.toJson()));
            }
        }
    }

    static {
        AutoConfig.getConfigHolder(PackedInventoryClothConfig.class).registerSaveListener((h, c) -> {
            c.onSave();
            return class_1269.field_5811;
        });
    }

    private static class ConfigSectionData {
        private final Supplier<Map<String, JsonElement>> serializedValuesSupplier;
        private final Supplier<Map<class_2960, PackedInventoryConfigEntryHolder<?>>> entriesSupplier;
        private final Supplier<DefaultedMap<class_2960, Object>> valuesSupplier;

        public ConfigSectionData(Supplier<Map<String, JsonElement>> serializedValuesSupplier, Supplier<Map<class_2960, PackedInventoryConfigEntryHolder<?>>> entriesSupplier, Supplier<DefaultedMap<class_2960, Object>> valuesSupplier) {
            this.serializedValuesSupplier = serializedValuesSupplier;
            this.entriesSupplier = entriesSupplier;
            this.valuesSupplier = valuesSupplier;
        }

        public Map<String, JsonElement> getSerializedValues() {
            return this.serializedValuesSupplier.get();
        }

        public Map<class_2960, PackedInventoryConfigEntryHolder<?>> getEntries() {
            return this.entriesSupplier.get();
        }

        public DefaultedMap<class_2960, Object> getValues() {
            return this.valuesSupplier.get();
        }
    }
}

