/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.packedinventory.inventory;

import dev.kir.packedinventory.api.v1.screen.InventoryDependentScreenHandlerFactory;
import dev.kir.packedinventory.item.NbtListItemStack;
import dev.kir.packedinventory.nbt.NbtListProvider;
import dev.kir.packedinventory.util.block.entity.BlockEntityUtil;
import dev.kir.packedinventory.util.inventory.InventoryUtil;
import dev.kir.packedinventory.util.inventory.NbtItemListUtil;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_3908;
import org.jetbrains.annotations.Nullable;

public abstract class NbtItemsInventory
implements class_1263,
NbtListProvider,
class_3908 {
    protected final class_1657 player;
    protected final class_1263 inventory;
    private final class_2371<class_1799> items;
    private class_1799 stack;
    private class_1799 stackCopy;

    protected NbtItemsInventory(class_1263 inventory, int index, class_1657 player) {
        this(inventory, inventory.method_5438(index), player);
    }

    protected NbtItemsInventory(class_1263 inventory, class_1799 stack, class_1657 player) {
        this.inventory = inventory;
        this.player = player;
        this.stack = stack;
        this.stackCopy = stack.method_7972();
        this.getNbtList().ifPresent(NbtItemListUtil::clean);
        this.getNbtList().ifPresent(NbtItemListUtil::sort);
        this.removeItemListIfEmpty();
        this.items = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
    }

    public static Builder builder(class_1263 inventory, int index, class_1657 player) {
        return new Builder(inventory, inventory.method_5438(index), player);
    }

    public static Builder builder(class_1263 inventory, class_1799 stack, class_1657 player) {
        return new Builder(inventory, stack, player);
    }

    public class_1263 getContainingInventory() {
        return this.inventory;
    }

    public class_1799 asStack() {
        return this.stack;
    }

    protected abstract class_2487 createNbtWithIdentifyingData();

    @Override
    public Optional<class_2499> getNbtList() {
        class_2487 nbt = class_1747.method_38072((class_1799)this.stack);
        return nbt == null || !nbt.method_10573("Items", 9) ? Optional.empty() : Optional.of(nbt.method_10554("Items", 10));
    }

    @Override
    public class_2499 getOrCreateNbtList() {
        class_2487 nbt = class_1747.method_38072((class_1799)this.stack);
        if (nbt == null) {
            nbt = this.createNbtWithIdentifyingData();
            this.stack.method_7959("BlockEntityTag", (class_2520)nbt);
        }
        if (!nbt.method_10573("Items", 9)) {
            nbt.method_10566("Items", (class_2520)new class_2499());
        }
        return nbt.method_10554("Items", 10);
    }

    protected void removeItemListIfEmpty() {
        class_2487 nbt = class_1747.method_38072((class_1799)this.stack);
        if (!(nbt == null || nbt.method_10573("Items", 9) && nbt.method_10554("Items", 10).size() != 0)) {
            this.stack.method_7983("BlockEntityTag");
        }
    }

    private void refreshNbtList() {
        this.removeItemListIfEmpty();
        this.inventory.method_5431();
    }

    public class_2561 method_5476() {
        return this.stack.method_7964();
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        InventoryDependentScreenHandlerFactory factory = InventoryDependentScreenHandlerFactory.genericOfSize(this.method_5439());
        return factory == null ? null : factory.createMenu(syncId, inv, this);
    }

    public abstract int method_5439();

    public boolean method_5442() {
        return this.getNbtList().map(x -> x.size() == 0).orElse(true);
    }

    public class_1799 method_5438(int slot) {
        class_1799 stack = (class_1799)this.items.get(slot);
        if (!(stack instanceof NbtListItemStack) || stack.method_7960()) {
            boolean isEmptyNbtListItemStack = false;
            if (stack instanceof NbtListItemStack) {
                isEmptyNbtListItemStack = true;
                ((NbtListItemStack)stack).unbound();
            }
            stack = NbtListItemStack.of(this, slot);
            this.items.set(slot, (Object)stack);
            if (isEmptyNbtListItemStack && stack.method_7960()) {
                this.getNbtList().ifPresent(list -> NbtItemListUtil.remove(list, slot));
                this.refreshNbtList();
            }
        }
        return stack;
    }

    public class_1799 method_5434(int slot, int amount) {
        class_1799 stack = this.method_5438(slot);
        if (stack.method_7960()) {
            return this.method_5441(slot);
        }
        class_1799 removed = stack.method_7971(amount);
        if (stack.method_7960() && stack instanceof NbtListItemStack) {
            this.items.set(slot, (Object)class_1799.field_8037);
            ((NbtListItemStack)stack).unbound();
        }
        this.refreshNbtList();
        return removed;
    }

    public class_1799 method_5441(int slot) {
        class_1799 stack = this.method_5438(slot);
        if (stack == class_1799.field_8037) {
            return class_1799.field_8037;
        }
        class_1799 removed = stack;
        this.items.set(slot, (Object)class_1799.field_8037);
        if (stack instanceof NbtListItemStack) {
            removed = stack.method_7972();
            ((NbtListItemStack)stack).unbound();
            this.getNbtList().ifPresent(list -> NbtItemListUtil.remove(list, slot));
            this.refreshNbtList();
        }
        return removed;
    }

    public void method_5447(int slot, class_1799 stack) {
        if (stack == this.items.get(slot)) {
            return;
        }
        this.method_5441(slot);
        if (!stack.method_7960()) {
            NbtItemListUtil.insert(this.getOrCreateNbtList(), slot, stack);
        }
    }

    public void method_5431() {
    }

    public boolean method_5437(int slot, class_1799 stack) {
        return stack != this.stack;
    }

    public boolean method_5443(class_1657 player) {
        if (this.player != player) {
            return false;
        }
        class_1799 cursorStack = this.player.field_7512.method_34255();
        if (!(this.stack.method_7960() || cursorStack != this.stack && InventoryUtil.indexOf(this.inventory, this.stack) == -1)) {
            return true;
        }
        class_1799 copy = this.getStackCopy();
        if (!cursorStack.method_7960() && class_1799.method_7973((class_1799)cursorStack, (class_1799)copy)) {
            this.updateItemStack(cursorStack);
            return true;
        }
        int i = InventoryUtil.indexOf(this.inventory, (x, s) -> class_1799.method_7973((class_1799)x, (class_1799)copy));
        if (i != -1) {
            this.updateItemStack(this.inventory.method_5438(i));
            return true;
        }
        return false;
    }

    protected void updateItemStack(class_1799 stack) {
        this.stack = stack;
        this.stackCopy = stack.method_7972();
    }

    private class_1799 getStackCopy() {
        this.stackCopy.method_7980(this.stack.method_7969());
        return this.stackCopy;
    }

    public void method_5448() {
        int size = this.method_5439();
        for (int i = 0; i < size; ++i) {
            this.method_5441(i);
        }
        this.getNbtList().ifPresent(class_2499::clear);
        this.removeItemListIfEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NbtItemsInventory)) {
            return false;
        }
        return this.stack == ((NbtItemsInventory)o).stack;
    }

    public static final class Builder {
        private final class_1657 player;
        private final class_1263 inventory;
        private final class_1799 stack;
        @Nullable
        private Integer size;
        @Nullable
        private Consumer<class_2487> nbtInitializer;
        @Nullable
        private InventoryDependentScreenHandlerFactory screenHandlerFactory;
        @Nullable
        private BiPredicate<class_1799, NbtItemsInventory> isValid;

        private Builder(class_1263 inventory, class_1799 stack, class_1657 player) {
            this.inventory = inventory;
            this.stack = stack;
            this.player = player;
        }

        public Builder size(int size) {
            this.size = size;
            return this;
        }

        public Builder nbtInitializer(Consumer<class_2487> nbtInitializer) {
            this.nbtInitializer = nbtInitializer;
            return this;
        }

        public Builder screenHandler(InventoryDependentScreenHandlerFactory screenHandlerFactory) {
            this.screenHandlerFactory = screenHandlerFactory;
            return this;
        }

        public Builder isValid(BiPredicate<class_1799, NbtItemsInventory> isValid) {
            this.isValid = isValid;
            return this;
        }

        public Builder resolveDefaults() {
            Optional<class_2591<?>> blockEntityTypeOptional = BlockEntityUtil.getBlockEntityType(this.stack.method_7909());
            if (blockEntityTypeOptional.isEmpty()) {
                if (this.size == null) {
                    this.size = this.getDefaultSize();
                }
                if (this.nbtInitializer == null) {
                    this.nbtInitializer = this.createDefaultNbtInitializer();
                }
            } else {
                class_2591<?> blockEntityType = blockEntityTypeOptional.get();
                if (this.size == null) {
                    this.size = BlockEntityUtil.getInventorySize(blockEntityType, this.getDefaultSize());
                }
                if (this.nbtInitializer == null) {
                    this.nbtInitializer = BlockEntityUtil.getBlockEntityItemStackInitializer(blockEntityType, this.stack.method_7909());
                }
            }
            if (this.screenHandlerFactory == null) {
                this.screenHandlerFactory = InventoryDependentScreenHandlerFactory.genericOfSize(this.size);
                if (this.screenHandlerFactory == null) {
                    this.screenHandlerFactory = InventoryDependentScreenHandlerFactory.EMPTY;
                }
            }
            return this;
        }

        private int getDefaultSize() {
            return BlockEntityUtil.getInventorySize(class_2591.field_11914, 27);
        }

        private Consumer<class_2487> createDefaultNbtInitializer() {
            return BlockEntityUtil.getBlockEntityItemStackInitializer(this.stack.method_7909());
        }

        public NbtItemsInventory build() {
            final int size = this.size == null ? this.getDefaultSize() : this.size.intValue();
            final Consumer<class_2487> nbtInitializer = this.nbtInitializer == null ? this.createDefaultNbtInitializer() : this.nbtInitializer;
            final InventoryDependentScreenHandlerFactory screenHandlerFactory = this.screenHandlerFactory;
            final BiPredicate<class_1799, NbtItemsInventory> isValid = this.isValid;
            return new NbtItemsInventory(this.inventory, this.stack, this.player){

                @Override
                protected class_2487 createNbtWithIdentifyingData() {
                    class_2487 nbt = new class_2487();
                    nbtInitializer.accept(nbt);
                    return nbt;
                }

                @Override
                public int method_5439() {
                    return size;
                }

                @Override
                @Nullable
                public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
                    return screenHandlerFactory == null ? super.createMenu(syncId, inv, player) : screenHandlerFactory.createMenu(syncId, inv, this);
                }

                @Override
                public boolean method_5437(int slot, class_1799 stack) {
                    return isValid == null ? super.method_5437(slot, stack) : isValid.test(stack, this);
                }
            };
        }
    }
}

