/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.packedinventory.item;

import dev.kir.packedinventory.item.EquatableItemStack;
import dev.kir.packedinventory.nbt.NbtListProvider;
import dev.kir.packedinventory.util.inventory.NbtItemListUtil;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public class NbtListItemStack
extends EquatableItemStack {
    @Nullable
    private NbtListProvider nbtListProvider;
    private int slot;

    private NbtListItemStack(class_1935 item, int count, @Nullable NbtListProvider nbtListProvider, int slot) {
        super(item, count);
        this.nbtListProvider = nbtListProvider;
        this.slot = slot;
        this.refreshNbt();
    }

    public static class_1799 of(NbtListProvider nbtListProvider, int slot) {
        class_2499 list = nbtListProvider.getNbtList().orElse(null);
        int i = list == null ? -1 : NbtItemListUtil.binarySearch(list, slot);
        class_1799 stack = i < 0 ? class_1799.field_8037 : NbtItemListUtil.asItemStack(list.method_10602(i));
        return stack.method_7960() ? class_1799.field_8037 : new NbtListItemStack((class_1935)stack.method_7909(), stack.method_7947(), nbtListProvider, slot);
    }

    public int method_7947() {
        if (!this.isUnbound()) {
            super.method_7939(this.get(class_1799::method_7947, 0).intValue());
        }
        return super.method_7947();
    }

    public void method_7939(int count) {
        super.method_7939(count);
        this.update(x -> x.method_7939(count));
    }

    public int method_7919() {
        int currentDamage;
        int realDamage;
        if (!this.isUnbound() && (realDamage = this.get(class_1799::method_7919, 0).intValue()) != (currentDamage = super.method_7919())) {
            super.method_7974(realDamage);
        }
        return super.method_7919();
    }

    public void method_7974(int damage) {
        super.method_7974(damage);
        this.update(x -> x.method_7974(damage));
    }

    public boolean method_7985() {
        this.refreshNbt();
        return super.method_7985();
    }

    @Nullable
    public class_2487 method_7969() {
        this.refreshNbt();
        return super.method_7969();
    }

    public void method_7980(@Nullable class_2487 nbt) {
        super.method_7980(nbt);
        this.update(x -> x.method_7980(nbt));
    }

    public class_2487 method_7911(String key) {
        this.refreshNbt();
        return super.method_7911(key);
    }

    @Nullable
    public class_2487 method_7941(String key) {
        class_2487 currentSubNbt;
        class_2487 realSubNbt;
        if (!this.isUnbound() && !Objects.equals(realSubNbt = (class_2487)this.get(x -> x.method_7941(key), null), currentSubNbt = super.method_7941(key))) {
            if (realSubNbt == null) {
                super.method_7983(key);
            } else {
                super.method_7959(key, (class_2520)realSubNbt);
            }
        }
        return super.method_7941(key);
    }

    public void method_7959(String key, class_2520 element) {
        super.method_7959(key, element);
        this.update(x -> x.method_7959(key, element));
    }

    public void method_7983(String key) {
        super.method_7983(key);
        this.update(x -> x.method_7983(key));
    }

    public class_2561 method_7964() {
        if (!this.isUnbound()) {
            return this.get(class_1799::method_7964, this.method_7909().method_7864((class_1799)this));
        }
        return super.method_7964();
    }

    public class_1799 method_7977(@Nullable class_2561 name) {
        super.method_7977(name);
        this.update(x -> x.method_7977(name));
        return this;
    }

    public boolean method_7938() {
        if (!this.isUnbound()) {
            return this.get(class_1799::method_7938, false);
        }
        return super.method_7938();
    }

    public boolean method_7942() {
        this.refreshNbt();
        return super.method_7942();
    }

    public class_2499 method_7921() {
        this.refreshNbt();
        return super.method_7921();
    }

    public void method_7978(class_1887 enchantment, int level) {
        super.method_7978(enchantment, level);
        this.update(x -> x.method_7978(enchantment, level));
    }

    @Nullable
    public class_1297 method_27319() {
        class_1297 currentHolder;
        class_1297 realHolder;
        if (!this.isUnbound() && !Objects.equals(realHolder = (class_1297)this.get(class_1799::method_27319, null), currentHolder = super.method_27319())) {
            super.method_27320(realHolder);
        }
        return super.method_27319();
    }

    public void method_27320(@Nullable class_1297 holder) {
        super.method_27320(holder);
        this.update(x -> x.method_27320(holder));
    }

    public int method_7928() {
        this.refreshNbt();
        return super.method_7928();
    }

    public void method_7927(int repairCost) {
        super.method_7927(repairCost);
        this.update(x -> x.method_7927(repairCost));
    }

    public void setSlot(int slot) {
        this.slot = slot;
    }

    public boolean isUnbound() {
        return this.nbtListProvider == null || this.slot < 0;
    }

    public void unbound() {
        this.nbtListProvider = null;
        this.slot = -1;
    }

    private void refreshNbt() {
        class_2487 currentNbt;
        if (this.isUnbound()) {
            return;
        }
        class_2487 realNbt = this.get(class_1799::method_7969, null);
        if (!Objects.equals(realNbt, currentNbt = super.method_7969())) {
            super.method_7980(realNbt);
        }
    }

    private <T> T get(Function<class_1799, T> getter, T defaultValue) {
        if (this.nbtListProvider == null || this.slot < 0) {
            return defaultValue;
        }
        class_2499 list = this.nbtListProvider.getNbtList().orElse(null);
        if (list == null) {
            return defaultValue;
        }
        return getter.apply(NbtItemListUtil.get(list, this.slot));
    }

    private void update(Consumer<class_1799> stackUpdater) {
        if (this.nbtListProvider == null || this.slot < 0) {
            return;
        }
        NbtItemListUtil.update(this.nbtListProvider.getOrCreateNbtList(), this.slot, stackUpdater);
    }
}

