/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.packedinventory.mixin;

import dev.kir.packedinventory.api.v1.networking.PackedInventoryBulkEditRequest;
import dev.kir.packedinventory.api.v1.networking.PackedInventoryEditRequest;
import dev.kir.packedinventory.client.input.KeyInfo;
import dev.kir.packedinventory.client.input.PackedInventoryKeyBindings;
import dev.kir.packedinventory.client.screen.CustomHandleableScreen;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_465.class})
abstract class HandledScreenMixin
extends class_437
implements CustomHandleableScreen {
    @Shadow
    protected int field_2776;
    @Shadow
    protected int field_2800;
    @Shadow
    @Final
    protected class_1703 field_2797;
    @Shadow
    @Nullable
    protected class_1735 field_2787;
    private boolean isInteracting = false;
    private final Set<class_1735> interactedSlots = new LinkedHashSet<class_1735>();

    private HandledScreenMixin(class_2561 title) {
        super(title);
    }

    @Shadow
    protected abstract boolean method_2381(double var1, double var3, int var5, int var6, int var7);

    @Shadow
    @Nullable
    protected abstract class_1735 method_2386(double var1, double var3);

    @Override
    public void handleCustomMouseMoved(double mouseX, double mouseY) {
        if (!this.isInteracting) {
            return;
        }
        class_1735 interactedSlot = this.method_2386(mouseX, mouseY);
        if (interactedSlot != null && this.interactedSlots.stream().findFirst().map(x -> x.method_7677().method_7960() == interactedSlot.method_7677().method_7960()).orElse(true).booleanValue()) {
            this.interactedSlots.add(interactedSlot);
        }
    }

    @Inject(method={"drawSlot"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;enableDepthTest()V", shift=At.Shift.BEFORE)})
    private void drawSlot(class_4587 matrices, class_1735 slot, CallbackInfo ci) {
        if (this.isInteracting && this.interactedSlots.size() > 1 && this.interactedSlots.contains(slot)) {
            HandledScreenMixin.method_25294((class_4587)matrices, (int)slot.field_7873, (int)slot.field_7872, (int)(slot.field_7873 + 16), (int)(slot.field_7872 + 16), (int)-2130706433);
        }
    }

    @Override
    public void handleCustomKeyPressed(KeyInfo key, double mouseX, double mouseY) {
        if (!key.matches(PackedInventoryKeyBindings.INTERACT_WITH_ITEM)) {
            return;
        }
        this.interactedSlots.clear();
        boolean bl = this.isInteracting = !this.field_2797.method_34255().method_7960();
        if (!this.isInteracting) {
            return;
        }
        class_1735 interactedSlot = this.method_2386(mouseX, mouseY);
        if (interactedSlot != null) {
            this.interactedSlots.add(interactedSlot);
        }
    }

    @Override
    public void handleCustomKeyReleased(KeyInfo key, double mouseX, double mouseY) {
        if (!key.matches(PackedInventoryKeyBindings.INTERACT_WITH_ITEM)) {
            return;
        }
        List<Integer> slotIndices = this.interactedSlots.stream().map(arg_0 -> this.field_2797.field_7761.indexOf(arg_0)).filter(x -> x >= 0).toList();
        this.interactedSlots.clear();
        this.isInteracting = false;
        if (slotIndices.size() > 1) {
            this.sendBulkEditRequest(slotIndices);
        } else {
            boolean isOutOfBounds = this.method_2381(mouseX, mouseY, this.field_2776, this.field_2800, 0);
            int focusedSlotIndex = !slotIndices.isEmpty() ? slotIndices.get(0) : (this.field_2787 == null ? -1 : this.field_2797.field_7761.indexOf((Object)this.field_2787));
            this.sendEditRequest(focusedSlotIndex, isOutOfBounds);
        }
    }

    private void sendEditRequest(int focusedSlotIndex, boolean isOutOfBounds) {
        int secondarySlotIndex;
        int primarySlotIndex;
        PackedInventoryEditRequest.ActionType actionType;
        PackedInventoryEditRequest.ActionType actionType2 = isOutOfBounds ? PackedInventoryEditRequest.ActionType.DROP : (actionType = this.field_2797.method_34255().method_7960() ? PackedInventoryEditRequest.ActionType.DEFAULT : PackedInventoryEditRequest.ActionType.QUICK_TRANSFER);
        if (focusedSlotIndex == -1) {
            if (actionType == PackedInventoryEditRequest.ActionType.QUICK_TRANSFER) {
                return;
            }
            focusedSlotIndex = -1;
        }
        if (actionType == PackedInventoryEditRequest.ActionType.QUICK_TRANSFER) {
            primarySlotIndex = -1;
            secondarySlotIndex = focusedSlotIndex;
        } else {
            primarySlotIndex = focusedSlotIndex;
            secondarySlotIndex = -1;
        }
        PackedInventoryEditRequest.sendToServer(actionType, primarySlotIndex, secondarySlotIndex, true);
    }

    private void sendBulkEditRequest(List<Integer> slotIndices) {
        if (this.field_2797.method_34255().method_7960()) {
            return;
        }
        PackedInventoryBulkEditRequest.sendToServer(PackedInventoryBulkEditRequest.ActionType.QUICK_TRANSFER, -1, slotIndices, true);
    }
}

