/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.packedinventory.mixin;

import dev.kir.packedinventory.api.v1.item.TooltipProviderContext;
import dev.kir.packedinventory.api.v1.item.TooltipProviderRegistry;
import dev.kir.packedinventory.api.v1.item.TooltipText;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_5632;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_1799.class})
abstract class ItemStackMixin {
    ItemStackMixin() {
    }

    @Inject(method={"getTooltipData"}, at={@At(value="RETURN")}, cancellable=true)
    private void getTooltipData(CallbackInfoReturnable<Optional<class_5632>> cir) {
        class_1799 it = (class_1799)this;
        TooltipProviderContext tooltipProviderContext = TooltipProviderContext.of((Optional)cir.getReturnValue());
        TooltipProviderRegistry.getInstance().getTooltipData(it, tooltipProviderContext).ifPresent(arg_0 -> cir.setReturnValue(arg_0));
    }

    @Inject(method={"getTooltip"}, at={@At(value="RETURN")}, cancellable=true)
    private void getTooltip(class_1657 player, class_1836 context, CallbackInfoReturnable<List<class_2561>> cir) {
        this.beginTooltipSectionAndAddMissingSections((List)cir.getReturnValue(), TooltipText.Part.UNKNOWN);
        class_1799 it = (class_1799)this;
        List list = (List)cir.getReturnValue();
        TooltipText.Builder builder = list instanceof TooltipText.BuilderList ? ((TooltipText.BuilderList)list).asBuilder() : TooltipText.builder(list);
        TooltipProviderContext tooltipProviderContext = TooltipProviderContext.of(builder.build(), player, context);
        TooltipProviderRegistry.getInstance().getTooltipText(it, tooltipProviderContext).ifPresent(arg_0 -> cir.setReturnValue(arg_0));
    }

    private void beginTooltipSectionAndAddMissingSections(List<class_2561> list, TooltipText.Part part) {
        int i;
        if (!(list instanceof TooltipText.BuilderList)) {
            return;
        }
        TooltipText.Builder builder = ((TooltipText.BuilderList)list).asBuilder();
        int ordinal = part.ordinal();
        TooltipText.Part[] parts = TooltipText.Part.values();
        for (i = ordinal; i > 0 && !builder.containsSection(parts[i - 1]); --i) {
        }
        while (i < ordinal) {
            builder.beginSection(parts[i]);
            ++i;
        }
        builder.beginSection(part);
    }

    @ModifyVariable(method={"getTooltip"}, at=@At(value="INVOKE", target="Lnet/minecraft/text/MutableText;formatted(Lnet/minecraft/util/Formatting;)Lnet/minecraft/text/MutableText;", shift=At.Shift.AFTER, ordinal=0))
    private List<class_2561> initTooltipTextBuilder(List<class_2561> list) {
        return TooltipText.builder(list).asList();
    }

    @Inject(method={"getTooltip"}, at={@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z", shift=At.Shift.BEFORE, ordinal=0)}, locals=LocalCapture.CAPTURE_FAILSOFT)
    private void beginNameTooltipSection(class_1657 player, class_1836 context, CallbackInfoReturnable<List<class_2561>> cir, List<class_2561> list) {
        this.beginTooltipSectionAndAddMissingSections(list, TooltipText.Part.NAME);
    }

    @Inject(method={"getTooltip"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/item/TooltipContext;isAdvanced()Z", shift=At.Shift.BEFORE, ordinal=0)}, locals=LocalCapture.CAPTURE_FAILSOFT)
    private void beginMapIdTooltipSection(class_1657 player, class_1836 context, CallbackInfoReturnable<List<class_2561>> cir, List<class_2561> list) {
        this.beginTooltipSectionAndAddMissingSections(list, TooltipText.Part.MAP_ID);
    }

    @Inject(method={"getTooltip"}, at={@At(value="INVOKE", target="Lnet/minecraft/nbt/NbtCompound;getType(Ljava/lang/String;)B", shift=At.Shift.BEFORE, ordinal=0)}, locals=LocalCapture.CAPTURE_FAILSOFT)
    private void beginLoreTooltipSection(class_1657 player, class_1836 context, CallbackInfoReturnable<List<class_2561>> cir, List<class_2561> list) {
        this.beginTooltipSectionAndAddMissingSections(list, TooltipText.Part.LORE);
    }

    @Inject(method={"getTooltip"}, at={@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z", shift=At.Shift.BEFORE, ordinal=15)}, locals=LocalCapture.CAPTURE_FAILSOFT)
    private void beginDurabilityTooltipSection(class_1657 player, class_1836 context, CallbackInfoReturnable<List<class_2561>> cir, List<class_2561> list) {
        this.beginTooltipSectionAndAddMissingSections(list, TooltipText.Part.DURABILITY);
    }

    @Inject(method={"getTooltip"}, at={@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z", shift=At.Shift.BEFORE, ordinal=16)}, locals=LocalCapture.CAPTURE_FAILSOFT)
    private void beginItemIdTooltipSection(class_1657 player, class_1836 context, CallbackInfoReturnable<List<class_2561>> cir, List<class_2561> list) {
        this.beginTooltipSectionAndAddMissingSections(list, TooltipText.Part.ITEM_ID);
    }

    @Inject(method={"getTooltip"}, at={@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z", shift=At.Shift.BEFORE, ordinal=17)}, locals=LocalCapture.CAPTURE_FAILSOFT)
    private void beginNbtTagsTooltipSection(class_1657 player, class_1836 context, CallbackInfoReturnable<List<class_2561>> cir, List<class_2561> list) {
        this.beginTooltipSectionAndAddMissingSections(list, TooltipText.Part.NBT_TAGS);
    }

    @Inject(method={"getTooltip"}, at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;isSectionVisible(ILnet/minecraft/item/ItemStack$TooltipSection;)Z", shift=At.Shift.BEFORE, ordinal=0)}, locals=LocalCapture.CAPTURE_FAILSOFT)
    private void beginAdditionalTooltipSection(class_1657 player, class_1836 context, CallbackInfoReturnable<List<class_2561>> cir, List<class_2561> list) {
        this.beginTooltipSectionAndAddMissingSections(list, TooltipText.Part.ADDITIONAL);
    }

    @Inject(method={"getTooltip"}, at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;isSectionVisible(ILnet/minecraft/item/ItemStack$TooltipSection;)Z", shift=At.Shift.BEFORE, ordinal=1)}, locals=LocalCapture.CAPTURE_FAILSOFT)
    private void beginEnchantmentsTooltipSection(class_1657 player, class_1836 context, CallbackInfoReturnable<List<class_2561>> cir, List<class_2561> list) {
        this.beginTooltipSectionAndAddMissingSections(list, TooltipText.Part.ENCHANTMENTS);
    }

    @Inject(method={"getTooltip"}, at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;isSectionVisible(ILnet/minecraft/item/ItemStack$TooltipSection;)Z", shift=At.Shift.BEFORE, ordinal=2)}, locals=LocalCapture.CAPTURE_FAILSOFT)
    private void beginDyeTooltipSection(class_1657 player, class_1836 context, CallbackInfoReturnable<List<class_2561>> cir, List<class_2561> list) {
        this.beginTooltipSectionAndAddMissingSections(list, TooltipText.Part.DYE);
    }

    @Inject(method={"getTooltip"}, at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;isSectionVisible(ILnet/minecraft/item/ItemStack$TooltipSection;)Z", shift=At.Shift.BEFORE, ordinal=3)}, locals=LocalCapture.CAPTURE_FAILSOFT)
    private void beginModifiersTooltipSection(class_1657 player, class_1836 context, CallbackInfoReturnable<List<class_2561>> cir, List<class_2561> list) {
        this.beginTooltipSectionAndAddMissingSections(list, TooltipText.Part.MODIFIERS);
    }

    @Inject(method={"getTooltip"}, at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;isSectionVisible(ILnet/minecraft/item/ItemStack$TooltipSection;)Z", shift=At.Shift.BEFORE, ordinal=4)}, locals=LocalCapture.CAPTURE_FAILSOFT)
    private void beginUnbreakableTooltipSection(class_1657 player, class_1836 context, CallbackInfoReturnable<List<class_2561>> cir, List<class_2561> list) {
        this.beginTooltipSectionAndAddMissingSections(list, TooltipText.Part.UNBREAKABLE);
    }

    @Inject(method={"getTooltip"}, at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;isSectionVisible(ILnet/minecraft/item/ItemStack$TooltipSection;)Z", shift=At.Shift.BEFORE, ordinal=5)}, locals=LocalCapture.CAPTURE_FAILSOFT)
    private void beginCanDestroyTooltipSection(class_1657 player, class_1836 context, CallbackInfoReturnable<List<class_2561>> cir, List<class_2561> list) {
        this.beginTooltipSectionAndAddMissingSections(list, TooltipText.Part.CAN_DESTROY);
    }

    @Inject(method={"getTooltip"}, at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;isSectionVisible(ILnet/minecraft/item/ItemStack$TooltipSection;)Z", shift=At.Shift.BEFORE, ordinal=6)}, locals=LocalCapture.CAPTURE_FAILSOFT)
    private void beginCanPlaceTooltipSection(class_1657 player, class_1836 context, CallbackInfoReturnable<List<class_2561>> cir, List<class_2561> list) {
        this.beginTooltipSectionAndAddMissingSections(list, TooltipText.Part.CAN_PLACE);
    }
}

