/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.packedinventory.util.block.entity;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.minecraft.class_1263;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2960;

public final class BlockEntityUtil {
    private static final Map<class_2591<?>, class_2586> BLOCK_ENTITIES = new ConcurrentHashMap();
    private static final Map<class_2591<?>, Integer> BLOCK_ENTITY_SIZES = new ConcurrentHashMap();
    private static final Map<class_2591<?>, Consumer<class_2487>> BLOCK_ENTITY_NBT_INITIALIZERS = new ConcurrentHashMap();
    private static final Map<class_1792, Consumer<class_2487>> ITEM_NBT_INITIALIZERS = new ConcurrentHashMap<class_1792, Consumer<class_2487>>();
    private static final Map<class_1792, Optional<class_2591<?>>> BLOCK_ENTITIES_BY_ITEM = new ConcurrentHashMap();
    private static final Collection<String> PREFIXES = Arrays.stream(class_1767.values()).map(x -> x.method_7792() + "_").toList();

    public static Optional<class_2591<?>> getBlockEntityType(class_1792 item) {
        Optional<class_2591<?>> result = BLOCK_ENTITIES_BY_ITEM.get(item);
        if (result == null) {
            class_2960 id = class_2378.field_11142.method_10221((Object)item);
            class_2591 blockEntityType = (class_2591)class_2378.field_11137.method_10223(id);
            if (blockEntityType == null) {
                String prefix = PREFIXES.stream().filter(id.method_12832()::startsWith).findFirst().orElse(null);
                if (prefix != null) {
                    class_2960 noPrefixId = new class_2960(id.method_12836(), id.method_12832().substring(prefix.length()));
                    blockEntityType = (class_2591)class_2378.field_11137.method_10223(noPrefixId);
                }
            }
            result = Optional.ofNullable(blockEntityType);
            BLOCK_ENTITIES_BY_ITEM.put(item, result);
        }
        return result;
    }

    public static Consumer<class_2487> getBlockEntityItemStackInitializer(class_1792 relevantItem) {
        Consumer<class_2487> initializer = ITEM_NBT_INITIALIZERS.get(relevantItem);
        if (initializer == null) {
            class_2960 id = class_2378.field_11142.method_10221((Object)relevantItem);
            class_2591 blockEntityType = (class_2591)class_2378.field_11137.method_10223(id);
            if (blockEntityType == null) {
                String idStr = id.toString();
                initializer = nbt -> nbt.method_10582("id", idStr);
            } else {
                initializer = BlockEntityUtil.getBlockEntityItemStackInitializer(blockEntityType, relevantItem);
            }
            ITEM_NBT_INITIALIZERS.put(relevantItem, initializer);
        }
        return initializer;
    }

    public static Consumer<class_2487> getBlockEntityItemStackInitializer(class_2591<?> blockEntityType, class_1792 relevantItem) {
        Consumer<class_2487> initializer = BLOCK_ENTITY_NBT_INITIALIZERS.get(blockEntityType);
        if (initializer == null) {
            Object be = BlockEntityUtil.getInstance(blockEntityType);
            if (be == null) {
                String id = class_2378.field_11142.method_10221((Object)relevantItem).toString();
                initializer = nbt -> nbt.method_10582("id", id);
            } else {
                initializer = x -> x.method_10543(be.method_38242());
            }
            BLOCK_ENTITY_NBT_INITIALIZERS.put(blockEntityType, initializer);
        }
        return initializer;
    }

    public static Optional<Integer> getInventorySize(class_2591<?> blockEntityType) {
        return Optional.ofNullable(BlockEntityUtil.getInventorySizeImpl(blockEntityType));
    }

    public static int getInventorySize(class_2591<?> blockEntityType, int defaultValue) {
        Integer size = BlockEntityUtil.getInventorySizeImpl(blockEntityType);
        return size == null ? defaultValue : size;
    }

    private static Integer getInventorySizeImpl(class_2591<?> blockEntityType) {
        Object be;
        Integer size = BLOCK_ENTITY_SIZES.get(blockEntityType);
        if (size == null && (be = BlockEntityUtil.getInstance(blockEntityType)) instanceof class_1263) {
            size = ((class_1263)be).method_5439();
            BLOCK_ENTITY_SIZES.put(blockEntityType, size);
        }
        return size;
    }

    public static <T extends class_2586> T getInstance(class_2591<T> blockEntityType) {
        return (T)BLOCK_ENTITIES.computeIfAbsent(blockEntityType, BlockEntityUtil::createInstance);
    }

    private static <T extends class_2586> T createInstance(class_2591<T> blockEntityType) {
        class_2248 block = (class_2248)class_2378.field_11146.method_10223(class_2378.field_11137.method_10221(blockEntityType));
        return (T)(blockEntityType.method_20526(block.method_9564()) ? blockEntityType.method_11032(class_2338.field_10980, block.method_9564()) : null);
    }

    private BlockEntityUtil() {
    }
}

