/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.packedinventory.util.collection;

import java.util.Map;
import java.util.Objects;
import net.minecraft.class_2960;

public abstract class KeyValuePair<K, V>
implements Map.Entry<K, V> {
    public static <K, V> KeyValuePair<K, V> of(K key, V value) {
        if (key instanceof class_2960) {
            return new IdentifierKeyValuePair<V>((class_2960)key, value);
        }
        return new GenericKeyValuePair<K, V>(key, value);
    }

    public abstract K setKey(K var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Map.Entry)) return false;
        Map.Entry entry = (Map.Entry)o;
        if (!Objects.equals(this.getKey(), entry.getKey())) return false;
        if (!Objects.equals(this.getValue(), entry.getValue())) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
    }

    public String toString() {
        return this.getKey() + "=" + this.getValue();
    }

    private static final class IdentifierKeyValuePair<V>
    extends KeyValuePair<class_2960, V> {
        private class_2960 key;
        private V value;

        private IdentifierKeyValuePair(class_2960 key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public class_2960 getKey() {
            return this.key;
        }

        @Override
        public class_2960 setKey(class_2960 key) {
            class_2960 oldKey = this.key;
            this.key = key;
            return oldKey;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }
    }

    private static final class GenericKeyValuePair<K, V>
    extends KeyValuePair<K, V> {
        private K key;
        private V value;

        private GenericKeyValuePair(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public K setKey(K key) {
            K oldKey = this.key;
            this.key = key;
            return oldKey;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }
    }
}

