/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.packedinventory.util.inventory;

import dev.kir.packedinventory.inventory.CombinedInventory;
import dev.kir.packedinventory.inventory.ListInventory;
import dev.kir.packedinventory.util.block.entity.BlockEntityUtil;
import java.util.Objects;
import java.util.function.BiPredicate;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import org.jetbrains.annotations.Nullable;

public final class InventoryUtil {
    public static final String ITEMS_KEY = "Items";
    public static final String SLOT_KEY = "Slot";
    public static final String SIZE_KEY = "Size";
    public static final String COUNT_KEY = "Count";
    public static final String BLOCK_ENTITY_TAG_KEY = "BlockEntityTag";

    public static int indexOf(class_1263 inventory, class_1799 stack) {
        int size = inventory.method_5439();
        for (int i = 0; i < size; ++i) {
            if (inventory.method_5438(i) != stack) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(class_1263 inventory, BiPredicate<class_1799, Integer> predicate) {
        int size = inventory.method_5439();
        for (int i = 0; i < size; ++i) {
            if (!predicate.test(inventory.method_5438(i), i)) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(class_1263 inventory, BiPredicate<class_1799, Integer> predicate) {
        for (int i = inventory.method_5439() - 1; i >= 0; --i) {
            if (!predicate.test(inventory.method_5438(i), i)) continue;
            return i;
        }
        return -1;
    }

    public static boolean hasInventory(class_1799 stack) {
        class_2487 blockEntityTag = stack.method_7941(BLOCK_ENTITY_TAG_KEY);
        if (blockEntityTag == null) {
            return false;
        }
        if (blockEntityTag.method_10573(ITEMS_KEY, 9)) {
            return blockEntityTag.method_10554(ITEMS_KEY, 10).size() != 0;
        }
        return false;
    }

    public static int firstIndexOf(class_1263 parentInventory, class_1263 targetInventory) {
        if (Objects.equals(parentInventory, targetInventory)) {
            return 0;
        }
        int currentIndex = 0;
        for (class_1263 innerInventory : CombinedInventory.asStream(parentInventory)::iterator) {
            if (Objects.equals(targetInventory, innerInventory)) {
                return currentIndex;
            }
            currentIndex += innerInventory.method_5439();
        }
        return -1;
    }

    public static boolean isSameSlot(class_1263 a, int aSlot, class_1263 b, int bSlot) {
        if (!(a instanceof CombinedInventory) && !(b instanceof CombinedInventory)) {
            return Objects.equals(a, b) && aSlot == bSlot;
        }
        for (class_1263 innerA : CombinedInventory.asStream(a)::iterator) {
            if (aSlot < innerA.method_5439()) {
                a = innerA;
                break;
            }
            aSlot -= innerA.method_5439();
        }
        for (class_1263 innerB : CombinedInventory.asStream(b)::iterator) {
            if (bSlot < innerB.method_5439()) {
                b = innerB;
                break;
            }
            bSlot -= innerB.method_5439();
        }
        return InventoryUtil.isSameSlot(a, aSlot, b, bSlot);
    }

    public static boolean canInsert(class_1263 inventory, int slot, class_1799 stack) {
        return InventoryUtil.canInsert(inventory, slot, stack, null);
    }

    public static boolean canInsert(class_1263 inventory, int slot, class_1799 stack, @Nullable class_2350 direction) {
        if (inventory instanceof class_1278) {
            return ((class_1278)inventory).method_5492(slot, stack, direction);
        }
        return inventory.method_5437(slot, stack);
    }

    public static boolean canInsertOrCombine(class_1263 inventory, int slot, class_1799 stack) {
        return InventoryUtil.canInsertOrCombine(inventory, slot, stack, null);
    }

    public static boolean canInsertOrCombine(class_1263 inventory, int slot, class_1799 stack, @Nullable class_2350 direction) {
        class_1799 currentStack = inventory.method_5438(slot);
        if (!currentStack.method_7960()) {
            return class_1799.method_31577((class_1799)currentStack, (class_1799)stack) && currentStack.method_7947() + stack.method_7947() <= currentStack.method_7914();
        }
        return InventoryUtil.canInsert(inventory, slot, stack, direction);
    }

    public static boolean canInsertOrPartiallyCombine(class_1263 inventory, int slot, class_1799 stack) {
        return InventoryUtil.canInsertOrPartiallyCombine(inventory, slot, stack, null);
    }

    public static boolean canInsertOrPartiallyCombine(class_1263 inventory, int slot, class_1799 stack, @Nullable class_2350 direction) {
        class_1799 currentStack = inventory.method_5438(slot);
        if (!currentStack.method_7960()) {
            return class_1799.method_31577((class_1799)currentStack, (class_1799)stack) && currentStack.method_7947() < currentStack.method_7914();
        }
        return InventoryUtil.canInsert(inventory, slot, stack, direction);
    }

    public static class_2371<class_1799> getInventory(class_1799 stack) {
        return InventoryUtil.getInventory(stack, InventoryUtil.getInventorySize(stack));
    }

    public static class_1263 zip(class_1263 inventory) {
        int size = inventory.method_5439();
        class_2371 items = class_2371.method_37434((int)size);
        for (int i = 0; i < size; ++i) {
            items.add((Object)inventory.method_5438(i));
        }
        return ListInventory.wrap(InventoryUtil.zip((class_2371<class_1799>)items));
    }

    public static class_2371<class_1799> zip(class_2371<class_1799> inventory) {
        class_2371 zipped = class_2371.method_37434((int)inventory.size());
        boolean[] empty = new boolean[inventory.size()];
        for (int i = 0; i < inventory.size(); ++i) {
            class_1799 stack = (class_1799)inventory.get(i);
            if (empty[i] || stack.method_7960()) continue;
            stack = stack.method_7972();
            for (int j = i + 1; j < inventory.size(); ++j) {
                class_1799 nextStack = (class_1799)inventory.get(j);
                if (empty[j] || !class_1799.method_31577((class_1799)stack, (class_1799)nextStack)) continue;
                stack.method_7939(stack.method_7947() + nextStack.method_7947());
                empty[j] = true;
            }
            zipped.add((Object)stack);
        }
        return zipped;
    }

    public static class_2371<class_1799> getInventory(class_1799 stack, int size) {
        class_2371 inventory = class_2371.method_10213((int)size, (Object)class_1799.field_8037);
        class_2499 list = InventoryUtil.getItemsList(stack);
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                int slot;
                class_2487 nbt = list.method_10602(i);
                int n = slot = nbt.method_10545(SLOT_KEY) ? nbt.method_10571(SLOT_KEY) & 0xFF : i;
                if (slot >= inventory.size()) continue;
                inventory.set(slot, (Object)class_1799.method_7915((class_2487)nbt));
            }
        }
        return inventory;
    }

    private static int getInventorySize(class_1799 stack) {
        int size = -1;
        class_2591 blockEntityType = BlockEntityUtil.getBlockEntityType(stack.method_7909()).orElse(null);
        if (blockEntityType != null) {
            size = BlockEntityUtil.getInventorySize(blockEntityType, -1);
        }
        if (size == -1) {
            int maxSlot = -1;
            int entryCount = 0;
            class_2499 list = InventoryUtil.getItemsList(stack);
            if (list != null) {
                for (class_2520 entry : list) {
                    if (entry instanceof class_2487 && ((class_2487)entry).method_10545(SLOT_KEY)) {
                        maxSlot = Math.max(maxSlot, ((class_2487)entry).method_10571(SLOT_KEY) & 0xFF);
                    }
                    ++entryCount;
                }
            }
            size = maxSlot == -1 ? entryCount : maxSlot + 1;
        }
        return size;
    }

    @Nullable
    private static class_2499 getItemsList(class_1799 stack) {
        class_2499 list;
        class_2487 nbt = class_1747.method_38072((class_1799)stack);
        class_2499 class_24992 = nbt == null ? null : (list = nbt.method_10545(ITEMS_KEY) ? nbt.method_10554(ITEMS_KEY, 10) : null);
        if (list != null) {
            return list;
        }
        nbt = stack.method_7969();
        return nbt == null ? null : (nbt.method_10545(ITEMS_KEY) ? nbt.method_10554(ITEMS_KEY, 10) : null);
    }

    private InventoryUtil() {
    }
}

