/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.packedinventory.util.inventory;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.function.Consumer;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public final class NbtItemListUtil {
    private static final Comparator<class_2520> COMPARATOR = Comparator.comparingInt(x -> x instanceof class_2487 ? (int)((class_2487)x).method_10571("Slot") : 0);

    public static void clean(class_2499 list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            class_2487 nbt = (class_2487)iterator.next();
            String id = nbt.method_10558("id");
            if (!"air".equals(id) && !"minecraft:air".equals(id) && nbt.method_10571("Count") > 0) continue;
            iterator.remove();
        }
    }

    public static void sort(class_2499 list) {
        list.sort(COMPARATOR);
    }

    public static int binarySearch(class_2499 list, int slot) {
        class_2487 target = new class_2487();
        target.method_10569("Slot", slot);
        return Collections.binarySearch(list, target, COMPARATOR);
    }

    public static class_1799 get(class_2499 list, int slot) {
        int i = NbtItemListUtil.binarySearch(list, slot);
        return i < 0 ? class_1799.field_8037 : NbtItemListUtil.asItemStack(list.method_10602(i));
    }

    public static class_1799 remove(class_2499 list, int slot) {
        int i = NbtItemListUtil.binarySearch(list, slot);
        if (i < 0) {
            return class_1799.field_8037;
        }
        class_1799 stack = NbtItemListUtil.asItemStack(list.method_10602(i));
        list.method_10536(i);
        return stack;
    }

    public static class_1799 remove(class_2499 list, int slot, int amount) {
        int i = NbtItemListUtil.binarySearch(list, slot);
        if (i < 0) {
            return class_1799.field_8037;
        }
        class_2487 stackNbt = list.method_10602(i);
        class_1799 stack = NbtItemListUtil.asItemStack(stackNbt);
        class_1799 splitStack = stack.method_7971(amount);
        if (stack.method_7960()) {
            list.method_10536(i);
        } else {
            stackNbt.method_10567("Count", (byte)stack.method_7947());
        }
        return splitStack;
    }

    public static void insert(class_2499 list, int slot, class_1799 stack) {
        if (stack.method_7960()) {
            NbtItemListUtil.remove(list, slot);
            return;
        }
        class_2487 stackNbt = NbtItemListUtil.asCompound(stack, slot);
        int i = NbtItemListUtil.binarySearch(list, slot);
        if (i >= 0) {
            list.method_10606(i, (class_2520)stackNbt);
            return;
        }
        if ((i = -i - 1) >= list.size()) {
            list.add((Object)stackNbt);
        } else {
            list.method_10531(i, (class_2520)stackNbt);
        }
    }

    public static void update(class_2499 list, int slot, Consumer<class_1799> stackUpdater) {
        int i = NbtItemListUtil.binarySearch(list, slot);
        if (i < 0) {
            return;
        }
        class_1799 stack = NbtItemListUtil.asItemStack(list.method_10602(i));
        stackUpdater.accept(stack);
        list.method_10606(i, (class_2520)NbtItemListUtil.asCompound(stack, slot));
    }

    public static class_2487 asCompound(class_1799 stack, int slot) {
        class_2487 nbt = new class_2487();
        nbt.method_10567("Slot", (byte)slot);
        stack.method_7953(nbt);
        return nbt;
    }

    public static class_1799 asItemStack(class_2487 nbt) {
        return class_1799.method_7915((class_2487)nbt);
    }

    private NbtItemListUtil() {
    }
}

