/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.util;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import me.shedaniel.rei.impl.common.InternalLogger;

public final class ThreadCreator {
    private final ThreadGroup group;
    private final AtomicInteger threadId = new AtomicInteger(0);

    public ThreadCreator(String groupName) {
        this.group = new ThreadGroup(groupName);
    }

    public ThreadGroup group() {
        return this.group;
    }

    public AtomicInteger threadId() {
        return this.threadId;
    }

    public Thread create(Runnable task) {
        Thread thread = new Thread(this.group(), task, this.group().getName() + "-" + this.threadId().getAndIncrement());
        thread.setDaemon(true);
        thread.setUncaughtExceptionHandler(($, exception) -> {
            if (!(exception instanceof InterruptedException || exception instanceof CancellationException || exception instanceof ThreadDeath)) {
                InternalLogger.getInstance().throwException(exception);
            }
        });
        return thread;
    }

    public ExecutorService asService() {
        return new ThreadPoolExecutor(0, Integer.MAX_VALUE, 10L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), this::create);
    }
}

