/*
 * Decompiled with CFR 0.152.
 */
package atonkish.reinfchest.client.render;

import atonkish.reinfcore.util.ReinforcingMaterial;
import java.util.LinkedHashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.event.client.ClientSpriteRegistryCallback;
import net.minecraft.class_1921;
import net.minecraft.class_2586;
import net.minecraft.class_2745;
import net.minecraft.class_2960;
import net.minecraft.class_4722;
import net.minecraft.class_4730;

@Environment(value=EnvType.CLIENT)
public class ModTexturedRenderLayers {
    public static final Map<ReinforcingMaterial, class_2960> REINFORCED_CHEST_ATLAS_TEXTURE_MAP = new LinkedHashMap<ReinforcingMaterial, class_2960>();
    private static final Map<ReinforcingMaterial, class_1921> REINFORCED_CHEST_RENDER_LAYER_MAP = new LinkedHashMap<ReinforcingMaterial, class_1921>();
    public static final Map<ReinforcingMaterial, class_4730> REINFORCED_CHEST_SINGLE_MAP = new LinkedHashMap<ReinforcingMaterial, class_4730>();
    public static final Map<ReinforcingMaterial, class_4730> REINFORCED_CHEST_LEFT_MAP = new LinkedHashMap<ReinforcingMaterial, class_4730>();
    public static final Map<ReinforcingMaterial, class_4730> REINFORCED_CHEST_RIGHT_MAP = new LinkedHashMap<ReinforcingMaterial, class_4730>();

    public static class_2960 registerMaterialAtlasTexture(String namespace, ReinforcingMaterial material) {
        if (!REINFORCED_CHEST_ATLAS_TEXTURE_MAP.containsKey(material)) {
            class_2960 identifier = new class_2960(namespace, "textures/atlas/" + material.getName() + "_chest.png");
            ClientSpriteRegistryCallback.event((class_2960)identifier).register((atlasTexture, registry) -> {
                String singlePath = "entity/reinforced_chest/" + material.getName() + "/single";
                String leftPath = "entity/reinforced_chest/" + material.getName() + "/left";
                String rightPath = "entity/reinforced_chest/" + material.getName() + "/right";
                registry.register(new class_2960(namespace, singlePath));
                registry.register(new class_2960(namespace, leftPath));
                registry.register(new class_2960(namespace, rightPath));
            });
            REINFORCED_CHEST_ATLAS_TEXTURE_MAP.put(material, identifier);
        }
        return REINFORCED_CHEST_ATLAS_TEXTURE_MAP.get(material);
    }

    public static class_1921 registerMaterialRenderLayer(ReinforcingMaterial material) {
        if (!REINFORCED_CHEST_RENDER_LAYER_MAP.containsKey(material)) {
            class_1921 renderLayer = class_1921.method_23576((class_2960)REINFORCED_CHEST_ATLAS_TEXTURE_MAP.get(material));
            REINFORCED_CHEST_RENDER_LAYER_MAP.put(material, renderLayer);
        }
        return REINFORCED_CHEST_RENDER_LAYER_MAP.get(material);
    }

    public static class_4730 registerMaterialSingleSprite(String namespace, ReinforcingMaterial material) {
        if (!REINFORCED_CHEST_SINGLE_MAP.containsKey(material)) {
            class_4730 identifier = ModTexturedRenderLayers.getReinforcedChestTextureId(namespace, material, "single");
            REINFORCED_CHEST_SINGLE_MAP.put(material, identifier);
        }
        return REINFORCED_CHEST_SINGLE_MAP.get(material);
    }

    public static class_4730 registerMaterialLeftSprite(String namespace, ReinforcingMaterial material) {
        if (!REINFORCED_CHEST_LEFT_MAP.containsKey(material)) {
            class_4730 identifier = ModTexturedRenderLayers.getReinforcedChestTextureId(namespace, material, "left");
            REINFORCED_CHEST_LEFT_MAP.put(material, identifier);
        }
        return REINFORCED_CHEST_LEFT_MAP.get(material);
    }

    public static class_4730 registerMaterialRightSprite(String namespace, ReinforcingMaterial material) {
        if (!REINFORCED_CHEST_RIGHT_MAP.containsKey(material)) {
            class_4730 identifier = ModTexturedRenderLayers.getReinforcedChestTextureId(namespace, material, "right");
            REINFORCED_CHEST_RIGHT_MAP.put(material, identifier);
        }
        return REINFORCED_CHEST_RIGHT_MAP.get(material);
    }

    public static class_1921 getReinforcedChest(ReinforcingMaterial material) {
        return REINFORCED_CHEST_RENDER_LAYER_MAP.get(material);
    }

    private static class_4730 getReinforcedChestTextureId(String namespace, ReinforcingMaterial material, String variant) {
        class_2960 atlasTexture = REINFORCED_CHEST_ATLAS_TEXTURE_MAP.get(material);
        class_2960 textureId = new class_2960(namespace, "entity/reinforced_chest/" + material.getName() + "/" + variant);
        return new class_4730(atlasTexture, textureId);
    }

    public static class_4730 getReinforcedChestTexture(ReinforcingMaterial material, class_2586 blockEntity, class_2745 type, boolean christmas) {
        if (christmas) {
            return ModTexturedRenderLayers.getReinforcedChestTexture(type, class_4722.field_21717, class_4722.field_21718, class_4722.field_21719);
        }
        class_4730 single = REINFORCED_CHEST_SINGLE_MAP.get(material);
        class_4730 left = REINFORCED_CHEST_LEFT_MAP.get(material);
        class_4730 right = REINFORCED_CHEST_RIGHT_MAP.get(material);
        return ModTexturedRenderLayers.getReinforcedChestTexture(type, single, left, right);
    }

    private static class_4730 getReinforcedChestTexture(class_2745 type, class_4730 single, class_4730 left, class_4730 right) {
        switch (type) {
            case field_12574: {
                return left;
            }
            case field_12571: {
                return right;
            }
        }
        return single;
    }
}

