/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;
import nx.pingwheel.client.Config;
import nx.pingwheel.client.PingWheelClient;

public class ConfigHandler {
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final Path configPath = FabricLoader.getInstance().getConfigDir();
    private final String configName;
    private int configHash;
    private Config config;

    protected ConfigHandler(String configName) {
        this.configName = configName;
        this.configHash = 0;
        this.config = new Config();
    }

    public Config getConfig() {
        return this.config;
    }

    public void save() {
        if (this.configHash == this.config.hashCode()) {
            return;
        }
        File configFile = this.configPath.resolve(this.configName).toFile();
        if (!configFile.exists()) {
            configFile.getParentFile().mkdirs();
            try {
                Files.createFile(configFile.toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                PingWheelClient.LOGGER.error("[Ping-Wheel] Creating Config failed: " + e);
                return;
            }
        }
        try {
            BufferedWriter writer = Files.newBufferedWriter(configFile.toPath(), new OpenOption[0]);
            this.gson.toJson((Object)this.config, (Appendable)writer);
            writer.close();
        }
        catch (Exception e) {
            PingWheelClient.LOGGER.error("[Ping-Wheel] Saving Config failed: " + e);
            return;
        }
        this.configHash = this.config.hashCode();
        PingWheelClient.LOGGER.info("[Ping-Wheel] Saved " + this.config);
    }

    public void load() {
        File configFile = this.configPath.resolve(this.configName).toFile();
        if (!configFile.exists()) {
            this.save();
            return;
        }
        try {
            BufferedReader reader = Files.newBufferedReader(configFile.toPath());
            this.config = (Config)this.gson.fromJson((Reader)reader, Config.class);
        }
        catch (Exception e) {
            this.config = null;
        }
        if (this.config == null) {
            this.config = new Config();
            PingWheelClient.LOGGER.info("[Ping-Wheel] Config is broken -> reset to defaults");
            this.save();
            return;
        }
        this.configHash = this.config.hashCode();
        PingWheelClient.LOGGER.info("[Ping-Wheel] Loaded " + this.config);
    }
}

