/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1087;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_1159;
import net.minecraft.class_1162;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_239;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3966;
import net.minecraft.class_4587;
import net.minecraft.class_5253;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_746;
import nx.pingwheel.PingWheel;
import nx.pingwheel.client.Config;
import nx.pingwheel.client.Core;
import nx.pingwheel.client.PingData;
import nx.pingwheel.client.PingWheelConfigHandler;
import nx.pingwheel.client.util.Draw;
import nx.pingwheel.client.util.ExtensionsKt;
import nx.pingwheel.client.util.Math;
import nx.pingwheel.client.util.RayCasting;
import nx.pingwheel.shared.Constants;
import nx.pingwheel.shared.DirectionalSoundInstance;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b1\u0010\bJ\u0017\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ/\u0010\u0011\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001f\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0015H\u0007\u00a2\u0006\u0004\b\u0017\u0010\u0018J'\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0017\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fR\u0014\u0010!\u001a\u00020 8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u0014\u0010$\u001a\u00020#8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b$\u0010%R\u001c\u0010(\u001a\n '*\u0004\u0018\u00010&0&8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010)R\u001c\u0010,\u001a\b\u0012\u0004\u0012\u00020+0*8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b,\u0010-R\u0016\u0010/\u001a\u00020.8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b/\u00100\u00a8\u00062"}, d2={"Lnx/pingwheel/client/Core;", "", "", "distance", "getDistanceScale", "(F)F", "", "markLocation", "()V", "Lnet/minecraft/class_310;", "client", "Lnet/minecraft/class_634;", "handler", "Lnet/minecraft/class_2540;", "buf", "Lnet/fabricmc/fabric/api/networking/v1/PacketSender;", "responseSender", "onReceivePing", "(Lnet/minecraft/class_310;Lnet/minecraft/class_634;Lnet/minecraft/class_2540;Lnet/fabricmc/fabric/api/networking/v1/PacketSender;)V", "Lnet/minecraft/class_4587;", "stack", "Lorg/spongepowered/asm/mixin/injection/callback/CallbackInfo;", "ci", "onRenderGUI", "(Lnet/minecraft/class_4587;Lorg/spongepowered/asm/mixin/injection/callback/CallbackInfo;)V", "Lnet/minecraft/class_1159;", "projectionMatrix", "tickDelta", "onRenderWorld", "(Lnet/minecraft/class_4587;Lnet/minecraft/class_1159;F)V", "processPing", "(F)V", "", "PING_LIFETIME", "I", "", "REACH_DISTANCE", "D", "Lnx/pingwheel/client/Config;", "kotlin.jvm.PlatformType", "config", "Lnx/pingwheel/client/Config;", "", "Lnx/pingwheel/client/PingData;", "pingRepo", "Ljava/util/List;", "", "queuePing", "Z", "<init>", "Ping-Wheel"})
public final class Core {
    @NotNull
    public static final Core INSTANCE = new Core();
    private static final double REACH_DISTANCE = 256.0;
    private static final int PING_LIFETIME = 140;
    private static final Config config = PingWheelConfigHandler.getInstance().getConfig();
    @NotNull
    private static List<PingData> pingRepo = new ArrayList();
    private static boolean queuePing;

    private Core() {
    }

    @JvmStatic
    public static final void markLocation() {
        queuePing = true;
    }

    private final void processPing(float tickDelta) {
        if (!queuePing) {
            return;
        }
        queuePing = false;
        class_1297 class_12972 = ExtensionsKt.getGame().field_1719;
        if (class_12972 == null) {
            return;
        }
        class_1297 cameraEntity = class_12972;
        class_243 cameraDirection = cameraEntity.method_5828(tickDelta);
        Intrinsics.checkNotNullExpressionValue((Object)cameraDirection, (String)"cameraDirection");
        class_239 hitResult = RayCasting.traceDirectional(cameraDirection, tickDelta, java.lang.Math.min(256.0, (double)Core.config.pingDistance), cameraEntity.method_5715());
        if (hitResult == null || hitResult.method_17783() == class_239.class_240.field_1333) {
            return;
        }
        class_2540 packet = PacketByteBufs.create();
        packet.method_10814(Core.config.channel);
        packet.writeDouble(hitResult.method_17784().field_1352);
        packet.writeDouble(hitResult.method_17784().field_1351);
        packet.writeDouble(hitResult.method_17784().field_1350);
        if (hitResult.method_17783() == class_239.class_240.field_1331) {
            packet.writeBoolean(true);
            packet.method_10797(((class_3966)hitResult).method_17782().method_5667());
        } else {
            packet.writeBoolean(false);
        }
        ClientPlayNetworking.send((class_2960)Constants.C2S_PING_LOCATION, (class_2540)packet);
    }

    private final float getDistanceScale(float distance) {
        float scaleMin = 1.0f;
        float scale = 2.0f / (float)java.lang.Math.pow(distance, 0.3f);
        return java.lang.Math.max(scaleMin, scale);
    }

    @JvmStatic
    public static final void onReceivePing(@NotNull class_310 client, @NotNull class_634 handler, @NotNull class_2540 buf, @NotNull PacketSender responseSender) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        Intrinsics.checkNotNullParameter((Object)responseSender, (String)"responseSender");
        String channel = buf.method_19772();
        if (!Intrinsics.areEqual((Object)channel, (Object)Core.config.channel)) {
            return;
        }
        class_243 pingPos = new class_243(buf.readDouble(), buf.readDouble(), buf.readDouble());
        if (Core.config.pingDistance < 2048) {
            class_243 vecToPing;
            class_746 class_7462 = ExtensionsKt.getGame().field_1724;
            class_243 class_2432 = class_7462 != null && (class_7462 = class_7462.method_19538()) != null ? class_7462.method_1035(pingPos) : (vecToPing = null);
            if (vecToPing != null && vecToPing.method_1033() > (double)Core.config.pingDistance) {
                return;
            }
        }
        UUID uuid = buf.readBoolean() ? buf.method_10790() : null;
        client.execute(() -> Core.onReceivePing$lambda$0(pingPos, uuid));
    }

    @JvmStatic
    public static final void onRenderWorld(@NotNull class_4587 stack, @NotNull class_1159 projectionMatrix, float tickDelta) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)projectionMatrix, (String)"projectionMatrix");
        class_638 class_6382 = ExtensionsKt.getGame().field_1687;
        if (class_6382 == null) {
            return;
        }
        class_638 world = class_6382;
        class_1159 modelViewMatrix = stack.method_23760().method_23761();
        INSTANCE.processPing(tickDelta);
        int time = (int)world.method_8510();
        for (PingData ping : pingRepo) {
            if (ping.getUuid() != null) {
                Object v1;
                block6: {
                    Iterable iterable;
                    Intrinsics.checkNotNullExpressionValue((Object)world.method_18112(), (String)"world.entities");
                    for (Object t : iterable) {
                        class_1297 entity = (class_1297)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)entity.method_5667(), (Object)ping.getUuid())) continue;
                        v1 = t;
                        break block6;
                    }
                    v1 = null;
                }
                class_1297 ent = v1;
                if (ent != null) {
                    if (Intrinsics.areEqual((Object)ent.method_5864(), (Object)class_1299.field_6052) && Core.config.itemIconVisible) {
                        class_1542 itemEnt = (class_1542)ent;
                        ping.setItemStack(itemEnt.method_6983().method_7972());
                    }
                    class_243 class_2432 = ent.method_30950(tickDelta).method_1031(0.0, ent.method_5829().method_17940(), 0.0);
                    Intrinsics.checkNotNullExpressionValue((Object)class_2432, (String)"ent.getLerpedPos(tickDel\u2026boundingBox.yLength, 0.0)");
                    ping.setPos(class_2432);
                }
            }
            class_243 class_2433 = ping.getPos();
            Intrinsics.checkNotNullExpressionValue((Object)modelViewMatrix, (String)"modelViewMatrix");
            ping.setScreenPos(Math.project3Dto2D(class_2433, modelViewMatrix, projectionMatrix));
            ping.setAliveTime(time - ping.getSpawnTime());
        }
        pingRepo.removeIf(arg_0 -> Core.onRenderWorld$lambda$2(onRenderWorld.1.INSTANCE, arg_0));
    }

    @JvmStatic
    public static final void onRenderGUI(@NotNull class_4587 stack, @NotNull CallbackInfo ci) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)ci, (String)"ci");
        for (PingData ping : pingRepo) {
            String text;
            class_1162 pingPosScreen;
            class_243 cameraPosVec;
            double uiScale = ExtensionsKt.getGame().method_22683().method_4495();
            float uiScaleAdjustment = Math.mapValue((float)uiScale, 1.0f, 5.0f, 1.0f, 2.0f);
            if (ping.getScreenPos() == null) continue;
            class_746 class_7462 = ExtensionsKt.getGame().field_1724;
            if ((class_7462 != null ? class_7462.method_5836(ExtensionsKt.getGame().method_1488()) : null) == null) continue;
            cameraPosVec = cameraPosVec;
            float distanceToPing = (float)cameraPosVec.method_1022(ping.getPos());
            float pingScale = INSTANCE.getDistanceScale(distanceToPing) / (float)uiScale * uiScaleAdjustment;
            int white = class_5253.class_5254.method_27764((int)255, (int)255, (int)255, (int)255);
            int shadowBlack = class_5253.class_5254.method_27764((int)64, (int)0, (int)0, (int)0);
            stack.method_22903();
            stack.method_22904((double)pingPosScreen.method_4953() / uiScale, (double)pingPosScreen.method_4956() / uiScale, 0.0);
            stack.method_22905(pingScale, pingScale, 1.0f);
            stack.method_22903();
            String string = "%.1fm";
            Object[] objectArray = new Object[]{Float.valueOf(distanceToPing)};
            Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray, objectArray.length)), (String)"format(this, *args)");
            class_241 textMetrics = new class_241((float)ExtensionsKt.getGame().field_1772.method_1727(text), (float)ExtensionsKt.getGame().field_1772.field_2000);
            class_241 textOffset = textMetrics.method_35582(-0.5f).method_35586(new class_241(0.0f, textMetrics.field_1342 * -1.5f));
            stack.method_22904((double)textOffset.field_1343, (double)textOffset.field_1342, 0.0);
            class_332.method_25294((class_4587)stack, (int)-2, (int)-2, (int)((int)textMetrics.field_1343 + 1), (int)((int)textMetrics.field_1342), (int)shadowBlack);
            ExtensionsKt.getGame().field_1772.method_1729(stack, text, 0.0f, 0.0f, white);
            stack.method_22909();
            if (ping.getItemStack() != null && Core.config.itemIconVisible) {
                class_1087 model = ExtensionsKt.getGame().method_1480().method_4019(ping.getItemStack(), null, null, 0);
                class_1799 class_17992 = ping.getItemStack();
                double d = (double)pingPosScreen.method_4953() / uiScale;
                double d2 = (double)pingPosScreen.method_4956() / uiScale;
                Intrinsics.checkNotNullExpressionValue((Object)model, (String)"model");
                Draw.renderGuiItemModel(class_17992, d, d2, model, stack, pingScale * (float)2 / (float)3);
            } else {
                ExtensionsKt.rotateZ(stack, 0.7853982f);
                stack.method_22904(-2.5, -2.5, 0.0);
                class_332.method_25294((class_4587)stack, (int)0, (int)0, (int)5, (int)5, (int)white);
            }
            stack.method_22909();
        }
    }

    private static final void onReceivePing$lambda$0(class_243 $pingPos, UUID $uuid) {
        Intrinsics.checkNotNullParameter((Object)$pingPos, (String)"$pingPos");
        class_638 class_6382 = ExtensionsKt.getGame().field_1687;
        pingRepo.add(new PingData($pingPos, $uuid, class_6382 != null ? (int)class_6382.method_8510() : 0, null, null, null, 56, null));
        class_1144 class_11442 = ExtensionsKt.getGame().method_1483();
        class_3414 class_34142 = PingWheel.PING_SOUND_EVENT;
        Intrinsics.checkNotNullExpressionValue((Object)class_34142, (String)"PING_SOUND_EVENT");
        class_11442.method_4873((class_1113)new DirectionalSoundInstance(class_34142, class_3419.field_15250, (float)Core.config.pingVolume / 100.0f, 1.0f, $pingPos));
    }

    private static final boolean onRenderWorld$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

