/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.file.GenericBuilder;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.function.BiConsumer;
import me.wesley1808.servercore.ServerCore;
import me.wesley1808.servercore.config.ConfigEntry;
import me.wesley1808.servercore.config.tables.ActivationRangeConfig;
import me.wesley1808.servercore.config.tables.CommandConfig;
import me.wesley1808.servercore.config.tables.DynamicConfig;
import me.wesley1808.servercore.config.tables.EntityLimitConfig;
import me.wesley1808.servercore.config.tables.FeatureConfig;
import net.fabricmc.loader.api.FabricLoader;

public final class Config {
    public static final Table[] TABLES = new Table[]{new Table(FeatureConfig.class, "features", "Lets you enable / disable certain features and modify them."), new Table(DynamicConfig.class, "dynamic", "Modifies mobcaps, no-chunk-tick, simulation and view-distance depending on the MSPT."), new Table(EntityLimitConfig.class, "entity_limits", "Stops animals / villagers from breeding if there are too many of the same type nearby."), new Table(CommandConfig.class, "commands", "Allows you to disable specific commands and modify the way some of them are formatted."), new Table(ActivationRangeConfig.class, "activation_range", "Stops entities from ticking if they are too far away.")};
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("servercore.toml");
    private static final GenericBuilder<CommentedConfig, CommentedFileConfig> BUILDER = CommentedFileConfig.builder((Path)CONFIG_PATH).preserveInsertionOrder().sync();

    public static void load() {
        CommentedFileConfig config = (CommentedFileConfig)BUILDER.build();
        config.load();
        for (Table table : TABLES) {
            Config.validate(table, config);
            Config.loadEntries((CommentedConfig)config.get(table.key), table.clazz);
        }
        Config.save();
    }

    public static void save() {
        CommentedFileConfig config = (CommentedFileConfig)BUILDER.build();
        for (Table table : TABLES) {
            Config.validate(table, config);
            Config.saveEntries((CommentedConfig)config.get(table.key), table.clazz);
            config.setComment(table.key, " " + table.comment);
        }
        config.save();
        config.close();
    }

    private static void validate(Table table, CommentedFileConfig config) {
        if (!config.contains(table.key)) {
            config.add(table.key, (Object)CommentedConfig.inMemory());
        }
    }

    private static void loadEntries(CommentedConfig config, Class<?> clazz) {
        try {
            Config.forEachEntry(clazz, (field, entry) -> {
                String key = field.getName().toLowerCase();
                Object value = config.getOrElse(key, entry.getDefault());
                if (!entry.set(value)) {
                    ServerCore.getLogger().error("[ServerCore] Invalid config entry found! {} = {}", (Object)key, value);
                }
            });
        }
        catch (Exception ex) {
            ServerCore.getLogger().error("[ServerCore] Exception was thrown whilst loading configs!", (Throwable)ex);
        }
    }

    private static void saveEntries(CommentedConfig config, Class<?> clazz) {
        try {
            config.clear();
            Config.forEachEntry(clazz, (field, entry) -> {
                String key = field.getName().toLowerCase();
                String comment = entry.getComment();
                config.set(key, entry.get());
                if (comment != null) {
                    config.setComment(key, " " + comment.replace("\n", "\n "));
                }
            });
        }
        catch (Exception ex) {
            ServerCore.getLogger().error("[ServerCore] Exception was thrown whilst saving configs!", (Throwable)ex);
        }
    }

    public static <T> void forEachEntry(Class<?> clazz, BiConsumer<Field, ConfigEntry<T>> consumer) throws IllegalAccessException {
        for (Field field : clazz.getFields()) {
            Object object = field.get(clazz);
            if (!(object instanceof ConfigEntry)) continue;
            ConfigEntry entry = (ConfigEntry)object;
            consumer.accept(field, entry);
        }
    }

    static {
        System.setProperty("nightconfig.preserveInsertionOrder", "true");
    }

    public record Table(Class<?> clazz, String key, String comment) {
    }
}

