/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.utils;

import java.math.BigDecimal;
import java.util.List;
import me.wesley1808.servercore.ServerCore;
import me.wesley1808.servercore.config.tables.CommandConfig;
import me.wesley1808.servercore.config.tables.DynamicConfig;
import me.wesley1808.servercore.config.tables.EntityLimitConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1923;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_3532;
import net.minecraft.server.MinecraftServer;

public final class TickManager {
    private static final BigDecimal VALUE = new BigDecimal("0.1");
    private static BigDecimal mobcapModifier = new BigDecimal(String.valueOf(DynamicConfig.MAX_MOBCAP.get()));
    private static double averageTickTime = 0.0;
    private static int viewDistance;
    private static int simulationDistance;
    private static int chunkTickDistance;

    public static void initValues(class_3324 playerList) {
        viewDistance = playerList.method_14568();
        simulationDistance = playerList.method_38651();
        chunkTickDistance = DynamicConfig.MAX_CHUNK_TICK_DISTANCE.get();
        if (DynamicConfig.ENABLED.get().booleanValue()) {
            int maxViewDistance = DynamicConfig.MAX_VIEW_DISTANCE.get();
            int maxSimDistance = DynamicConfig.MAX_SIMULATION_DISTANCE.get();
            if (viewDistance > maxViewDistance) {
                TickManager.modifyViewDistance(maxViewDistance);
            }
            if (simulationDistance > maxSimDistance) {
                TickManager.modifySimulationDistance(maxSimDistance);
            }
        }
    }

    public static void update(MinecraftServer server) {
        TickManager.updateValues(server);
        TickManager.runPerformanceChecks(server);
    }

    private static void updateValues(MinecraftServer server) {
        if (server.method_3780() % 20 == 0) {
            averageTickTime = class_3532.method_15373((long[])server.field_4573) * 1.0E-6;
        }
    }

    private static void runPerformanceChecks(MinecraftServer server) {
        if (DynamicConfig.ENABLED.get().booleanValue()) {
            double targetMspt = DynamicConfig.TARGET_MSPT.get().intValue();
            double upperBound = targetMspt + 5.0;
            double lowerBound = Math.max(targetMspt - 5.0, 2.0);
            if (server.method_3780() % (DynamicConfig.VIEW_DISTANCE_UPDATE_RATE.get() * 20) == 0) {
                TickManager.checkViewDistance(upperBound, lowerBound);
            }
            if (server.method_3780() % (DynamicConfig.UPDATE_RATE.get() * 20) == 0) {
                TickManager.checkSimulationDistance(upperBound, lowerBound);
                TickManager.checkMobcaps(upperBound, lowerBound);
                TickManager.checkChunkTickDistance(upperBound, lowerBound);
            }
        }
    }

    private static void checkChunkTickDistance(double upperBound, double lowerBound) {
        if (averageTickTime > upperBound && chunkTickDistance > DynamicConfig.MIN_CHUNK_TICK_DISTANCE.get()) {
            --chunkTickDistance;
        } else if (averageTickTime < lowerBound && chunkTickDistance < DynamicConfig.MAX_CHUNK_TICK_DISTANCE.get() && mobcapModifier.doubleValue() >= DynamicConfig.MAX_MOBCAP.get()) {
            ++chunkTickDistance;
        }
    }

    private static void checkMobcaps(double upperBound, double lowerBound) {
        if (averageTickTime > upperBound && mobcapModifier.doubleValue() > DynamicConfig.MIN_MOBCAP.get() && chunkTickDistance <= DynamicConfig.MIN_CHUNK_TICK_DISTANCE.get()) {
            mobcapModifier = mobcapModifier.subtract(VALUE);
        } else if (averageTickTime < lowerBound && mobcapModifier.doubleValue() < DynamicConfig.MAX_MOBCAP.get() && simulationDistance >= DynamicConfig.MAX_SIMULATION_DISTANCE.get()) {
            mobcapModifier = mobcapModifier.add(VALUE);
        }
    }

    private static void checkSimulationDistance(double upperBound, double lowerBound) {
        if (averageTickTime > upperBound && simulationDistance > DynamicConfig.MIN_SIMULATION_DISTANCE.get() && mobcapModifier.doubleValue() <= DynamicConfig.MIN_MOBCAP.get()) {
            TickManager.modifySimulationDistance(simulationDistance - 1);
        } else if (averageTickTime < lowerBound && simulationDistance < DynamicConfig.MAX_SIMULATION_DISTANCE.get() && viewDistance >= DynamicConfig.MAX_VIEW_DISTANCE.get()) {
            TickManager.modifySimulationDistance(simulationDistance + 1);
        }
    }

    private static void checkViewDistance(double upperBound, double lowerBound) {
        if (averageTickTime > upperBound && viewDistance > DynamicConfig.MIN_VIEW_DISTANCE.get() && simulationDistance <= DynamicConfig.MIN_SIMULATION_DISTANCE.get()) {
            TickManager.modifyViewDistance(viewDistance - 1);
        } else if (averageTickTime < lowerBound && viewDistance < DynamicConfig.MAX_VIEW_DISTANCE.get()) {
            TickManager.modifyViewDistance(viewDistance + 1);
        }
    }

    public static void modifyViewDistance(int distance) {
        ServerCore.getServer().method_3760().method_14608(distance);
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            class_310.method_1551().field_1690.field_1870 = distance;
        }
    }

    public static void modifySimulationDistance(int distance) {
        ServerCore.getServer().method_3760().method_38650(distance);
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            class_310.method_1551().field_1690.field_34959 = distance;
        }
    }

    public static void setViewDistance(int distance) {
        viewDistance = distance;
    }

    public static void setSimulationDistance(int distance) {
        simulationDistance = distance;
    }

    public static void setChunkTickDistance(int distance) {
        chunkTickDistance = distance;
    }

    public static void setModifier(BigDecimal modifier) {
        mobcapModifier = modifier;
    }

    public static double getAverageTickTime() {
        return averageTickTime;
    }

    public static int getViewDistance() {
        return viewDistance;
    }

    public static int getSimulationDistance() {
        return simulationDistance;
    }

    public static double getMobcapModifier() {
        return mobcapModifier.doubleValue();
    }

    public static String getModifierAsString() {
        return String.format("%.1f", mobcapModifier.doubleValue());
    }

    public static boolean shouldTickChunk(class_1923 pos, class_3218 level) {
        if (chunkTickDistance >= viewDistance) {
            return true;
        }
        for (class_3222 player : level.method_18456()) {
            if (player.field_13974.method_14257() == class_1934.field_9219 || player.method_31476().method_24022(pos) > chunkTickDistance) continue;
            return true;
        }
        return false;
    }

    public static boolean checkForEntities(class_1299<?> type, class_1937 level, class_2338 pos, int limit, int range) {
        if (EntityLimitConfig.ENABLED.get().booleanValue()) {
            return limit <= level.method_18023(type, TickManager.getBox(pos, range), class_1301.field_6155).size();
        }
        return false;
    }

    public static boolean checkForEntities(List<class_1299<?>> types, class_1937 level, class_2338 pos, int limit, int range) {
        if (EntityLimitConfig.ENABLED.get().booleanValue()) {
            return limit <= level.method_8333((class_1297)null, TickManager.getBox(pos, range), e -> types.contains(e.method_5864())).size();
        }
        return false;
    }

    public static boolean checkForEntities(class_1297 entity, int limit, int range) {
        return TickManager.checkForEntities(entity.method_5864(), entity.method_37908(), entity.method_24515(), limit, range);
    }

    private static class_238 getBox(class_2338 pos, int range) {
        return new class_238(pos.method_25503().method_10069(range, range, range), pos.method_25503().method_10069(-range, -range, -range));
    }

    public static String createStatusReport(String title) {
        return title + "\n" + CommandConfig.STATUS_CONTENT.get().replace("%VERSION%", ServerCore.getVersion()).replace("%MOBCAPS%", TickManager.getModifierAsString()).replace("%VIEW_DISTANCE%", String.valueOf(viewDistance)).replace("%SIMULATION_DISTANCE%", String.valueOf(simulationDistance)).replace("%CHUNK_TICK_DISTANCE%", String.valueOf(chunkTickDistance));
    }
}

