/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.utils;

import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.minecraft.class_1657;
import net.minecraft.class_2168;

public final class Util {
    public static <T> boolean displayPage(List<T> list, int page, int pageSize, BiConsumer<T, Integer> consumer) {
        int index = Util.getIndex(page, pageSize);
        int toIndex = Math.min(index + pageSize, list.size());
        if (toIndex <= index) {
            return false;
        }
        for (T value : list.subList(index, toIndex)) {
            consumer.accept(value, ++index);
        }
        return true;
    }

    public static int getIndex(int page, int pageSize) {
        return pageSize * (page - 1);
    }

    public static int getPage(int index, int pageSize) {
        return (index + pageSize - 1) / pageSize;
    }

    public static boolean isPlayer(class_2168 source) {
        return source.method_9228() instanceof class_1657;
    }

    public static <K, V extends Comparable<V>> List<Map.Entry<K, V>> sortByValue(Map<K, V> map) {
        ArrayList<Map.Entry<K, V>> entries = new ArrayList<Map.Entry<K, V>>(map.entrySet());
        entries.sort((c1, c2) -> ((Comparable)c2.getValue()).compareTo((Comparable)c1.getValue()));
        return entries;
    }

    public static CompletableFuture<Suggestions> suggestAll(SuggestionsBuilder builder, String ... suggestions) {
        for (String suggestion : suggestions) {
            builder.suggest(suggestion);
        }
        return builder.buildFuture();
    }
}

