/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.fabric;

import com.google.common.collect.ImmutableMap;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import me.lucko.spark.common.util.ClassSourceLookup;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;

public class FabricClassSourceLookup
extends ClassSourceLookup.ByCodeSource {
    private final Path modsDirectory;
    private final Map<Path, String> pathToModMap;

    public FabricClassSourceLookup() {
        FabricLoader loader = FabricLoader.getInstance();
        this.modsDirectory = loader.getGameDir().resolve("mods").toAbsolutePath().normalize();
        this.pathToModMap = FabricClassSourceLookup.constructPathToModIdMap(loader.getAllMods());
    }

    @Override
    public String identifyFile(Path path) {
        String id = this.pathToModMap.get(path);
        if (id != null) {
            return id;
        }
        if (!path.startsWith(this.modsDirectory)) {
            return null;
        }
        return super.identifyFileName(this.modsDirectory.relativize(path).toString());
    }

    private static Map<Path, String> constructPathToModIdMap(Collection<ModContainer> mods) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ModContainer mod : mods) {
            Path path = mod.getRootPath().toAbsolutePath().normalize();
            builder.put((Object)path, (Object)mod.getMetadata().getId());
        }
        return builder.build();
    }
}

