/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.fabric.placeholder;

import eu.pb4.placeholders.PlaceholderAPI;
import eu.pb4.placeholders.PlaceholderResult;
import me.lucko.spark.common.SparkPlatform;
import me.lucko.spark.common.monitor.cpu.CpuMonitor;
import me.lucko.spark.common.monitor.tick.TickStatistics;
import me.lucko.spark.common.util.RollingAverage;
import me.lucko.spark.common.util.StatisticFormatter;
import me.lucko.spark.lib.adventure.text.Component;
import me.lucko.spark.lib.adventure.text.TextComponent;
import me.lucko.spark.lib.adventure.text.serializer.gson.GsonComponentSerializer;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class SparkFabricPlaceholderApi {
    private final SparkPlatform platform;

    public SparkFabricPlaceholderApi(SparkPlatform platform) {
        this.platform = platform;
        PlaceholderAPI.register((class_2960)new class_2960("spark", "tps"), context -> {
            TickStatistics tickStatistics = platform.getTickStatistics();
            if (tickStatistics == null) {
                return PlaceholderResult.invalid();
            }
            if (context.hasArgument()) {
                Double tps;
                switch (context.getArgument()) {
                    case "5s": {
                        Double d = tickStatistics.tps5Sec();
                        break;
                    }
                    case "10s": {
                        Double d = tickStatistics.tps10Sec();
                        break;
                    }
                    case "1m": {
                        Double d = tickStatistics.tps1Min();
                        break;
                    }
                    case "5m": {
                        Double d = tickStatistics.tps5Min();
                        break;
                    }
                    case "15m": {
                        Double d = tickStatistics.tps15Min();
                        break;
                    }
                    default: {
                        Double d = tps = null;
                    }
                }
                if (tps == null) {
                    return PlaceholderResult.invalid((String)"Invalid argument");
                }
                return PlaceholderResult.value((class_2561)this.toText(StatisticFormatter.formatTps(tps)));
            }
            return PlaceholderResult.value((class_2561)this.toText((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)StatisticFormatter.formatTps(tickStatistics.tps5Sec()))).append((Component)Component.text(", "))).append((Component)StatisticFormatter.formatTps(tickStatistics.tps10Sec()))).append((Component)Component.text(", "))).append((Component)StatisticFormatter.formatTps(tickStatistics.tps1Min()))).append((Component)Component.text(", "))).append((Component)StatisticFormatter.formatTps(tickStatistics.tps5Min()))).append((Component)Component.text(", "))).append((Component)StatisticFormatter.formatTps(tickStatistics.tps15Min()))).build()));
        });
        PlaceholderAPI.register((class_2960)new class_2960("spark", "tickduration"), context -> {
            TickStatistics tickStatistics = platform.getTickStatistics();
            if (tickStatistics == null || !tickStatistics.isDurationSupported()) {
                return PlaceholderResult.invalid();
            }
            if (context.hasArgument()) {
                RollingAverage duration;
                switch (context.getArgument()) {
                    case "10s": {
                        RollingAverage rollingAverage = tickStatistics.duration10Sec();
                        break;
                    }
                    case "1m": {
                        RollingAverage rollingAverage = tickStatistics.duration1Min();
                        break;
                    }
                    default: {
                        RollingAverage rollingAverage = duration = null;
                    }
                }
                if (duration == null) {
                    return PlaceholderResult.invalid((String)"Invalid argument");
                }
                return PlaceholderResult.value((class_2561)this.toText(StatisticFormatter.formatTickDurations(duration)));
            }
            return PlaceholderResult.value((class_2561)this.toText((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)StatisticFormatter.formatTickDurations(tickStatistics.duration10Sec()))).append((Component)Component.text(";  "))).append((Component)StatisticFormatter.formatTickDurations(tickStatistics.duration1Min()))).build()));
        });
        PlaceholderAPI.register((class_2960)new class_2960("spark", "cpu_system"), context -> {
            if (context.hasArgument()) {
                Double usage;
                switch (context.getArgument()) {
                    case "10s": {
                        Double d = CpuMonitor.systemLoad10SecAvg();
                        break;
                    }
                    case "1m": {
                        Double d = CpuMonitor.systemLoad1MinAvg();
                        break;
                    }
                    case "15m": {
                        Double d = CpuMonitor.systemLoad15MinAvg();
                        break;
                    }
                    default: {
                        Double d = usage = null;
                    }
                }
                if (usage == null) {
                    return PlaceholderResult.invalid((String)"Invalid argument");
                }
                return PlaceholderResult.value((class_2561)this.toText(StatisticFormatter.formatCpuUsage(usage)));
            }
            return PlaceholderResult.value((class_2561)this.toText((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)StatisticFormatter.formatCpuUsage(CpuMonitor.systemLoad10SecAvg()))).append((Component)Component.text(", "))).append((Component)StatisticFormatter.formatCpuUsage(CpuMonitor.systemLoad1MinAvg()))).append((Component)Component.text(", "))).append((Component)StatisticFormatter.formatCpuUsage(CpuMonitor.systemLoad15MinAvg()))).build()));
        });
        PlaceholderAPI.register((class_2960)new class_2960("spark", "cpu_process"), context -> {
            if (context.hasArgument()) {
                Double usage;
                switch (context.getArgument()) {
                    case "10s": {
                        Double d = CpuMonitor.processLoad10SecAvg();
                        break;
                    }
                    case "1m": {
                        Double d = CpuMonitor.processLoad1MinAvg();
                        break;
                    }
                    case "15m": {
                        Double d = CpuMonitor.processLoad15MinAvg();
                        break;
                    }
                    default: {
                        Double d = usage = null;
                    }
                }
                if (usage == null) {
                    return PlaceholderResult.invalid((String)"Invalid argument");
                }
                return PlaceholderResult.value((class_2561)this.toText(StatisticFormatter.formatCpuUsage(usage)));
            }
            return PlaceholderResult.value((class_2561)this.toText((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)StatisticFormatter.formatCpuUsage(CpuMonitor.processLoad10SecAvg()))).append((Component)Component.text(", "))).append((Component)StatisticFormatter.formatCpuUsage(CpuMonitor.processLoad1MinAvg()))).append((Component)Component.text(", "))).append((Component)StatisticFormatter.formatCpuUsage(CpuMonitor.processLoad15MinAvg()))).build()));
        });
    }

    private class_2561 toText(Component component) {
        return class_2561.class_2562.method_10877((String)((String)GsonComponentSerializer.gson().serialize(component)));
    }
}

