/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.fabric.plugin;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import me.lucko.spark.common.platform.PlatformInfo;
import me.lucko.spark.common.tick.TickHook;
import me.lucko.spark.common.tick.TickReporter;
import me.lucko.spark.fabric.FabricCommandSender;
import me.lucko.spark.fabric.FabricPlatformInfo;
import me.lucko.spark.fabric.FabricSparkGameHooks;
import me.lucko.spark.fabric.FabricSparkMod;
import me.lucko.spark.fabric.FabricTickHook;
import me.lucko.spark.fabric.FabricTickReporter;
import me.lucko.spark.fabric.plugin.FabricSparkPlugin;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.minecraft.class_2165;
import net.minecraft.class_2172;
import net.minecraft.class_310;
import net.minecraft.class_634;

public class FabricClientSparkPlugin
extends FabricSparkPlugin
implements SuggestionProvider<class_2172> {
    private final class_310 minecraft;
    private CommandDispatcher<class_2172> dispatcher;

    public static void register(FabricSparkMod mod, class_310 client) {
        FabricClientSparkPlugin plugin = new FabricClientSparkPlugin(mod, client);
        plugin.enable();
    }

    public FabricClientSparkPlugin(FabricSparkMod mod, class_310 minecraft) {
        super(mod);
        this.minecraft = minecraft;
    }

    @Override
    public void enable() {
        super.enable();
        this.scheduler.scheduleWithFixedDelay(this::checkCommandRegistered, 10L, 10L, TimeUnit.SECONDS);
        ClientLifecycleEvents.CLIENT_STOPPING.register(this::onDisable);
    }

    private void onDisable(class_310 stoppingClient) {
        if (stoppingClient == this.minecraft) {
            this.disable();
        }
    }

    private CommandDispatcher<class_2172> getPlayerCommandDispatcher() {
        return Optional.ofNullable(this.minecraft.field_1724).map(player -> player.field_3944).map(class_634::method_2886).orElse(null);
    }

    private void checkCommandRegistered() {
        CommandDispatcher<class_2172> dispatcher = this.getPlayerCommandDispatcher();
        if (dispatcher == null) {
            return;
        }
        try {
            if (dispatcher != this.dispatcher) {
                this.dispatcher = dispatcher;
                FabricClientSparkPlugin.registerCommands(this.dispatcher, c -> 1, this, "sparkc", "sparkclient");
                FabricSparkGameHooks.INSTANCE.setChatSendCallback(this::onClientChat);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean onClientChat(String chat) {
        String[] args = FabricClientSparkPlugin.processArgs(chat, false);
        if (args == null) {
            return false;
        }
        this.threadDumper.ensureSetup();
        this.platform.executeCommand(new FabricCommandSender((class_2165)this.minecraft.field_1724, this), args);
        this.minecraft.field_1705.method_1743().method_1803(chat);
        return true;
    }

    public CompletableFuture<Suggestions> getSuggestions(CommandContext<class_2172> context, SuggestionsBuilder builder) throws CommandSyntaxException {
        String[] args = FabricClientSparkPlugin.processArgs(context.getInput(), true);
        if (args == null) {
            return Suggestions.empty();
        }
        return this.generateSuggestions(new FabricCommandSender((class_2165)this.minecraft.field_1724, this), args, builder);
    }

    private static String[] processArgs(String input, boolean tabComplete) {
        String[] split = input.split(" ", tabComplete ? -1 : 0);
        if (split.length == 0 || !split[0].equals("/sparkc") && !split[0].equals("/sparkclient")) {
            return null;
        }
        return Arrays.copyOfRange(split, 1, split.length);
    }

    @Override
    public boolean hasPermission(class_2165 sender, String permission) {
        return true;
    }

    public Stream<FabricCommandSender> getCommandSenders() {
        return Stream.of(new FabricCommandSender((class_2165)this.minecraft.field_1724, this));
    }

    @Override
    public TickHook createTickHook() {
        return new FabricTickHook.Client();
    }

    @Override
    public TickReporter createTickReporter() {
        return new FabricTickReporter.Client();
    }

    @Override
    public PlatformInfo getPlatformInfo() {
        return new FabricPlatformInfo(PlatformInfo.Type.CLIENT);
    }

    @Override
    public String getCommandName() {
        return "sparkc";
    }
}

