/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.auudio.audio;

import de.keksuccino.auudio.audio.AudioClipSound;
import de.keksuccino.auudio.audio.AudioClipSoundInstance;
import de.keksuccino.auudio.audio.AudioHandler;
import de.keksuccino.auudio.audio.VanillaSoundUtils;
import de.keksuccino.auudio.audio.exceptions.InvalidAudioException;
import de.keksuccino.auudio.audio.external.ExternalSound;
import de.keksuccino.auudio.audio.external.ExternalSoundResourceLocation;
import de.keksuccino.auudio.mixin.client.IMixinChannel;
import net.minecraft.class_1111;
import net.minecraft.class_1113;
import net.minecraft.class_1146;
import net.minecraft.class_1148;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_4224;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.openal.AL10;

public class AudioClip {
    protected final SoundType soundType;
    protected class_2960 soundLocation;
    protected class_1146 soundEvents;
    protected AudioClipSound sound;
    protected AudioClipSoundInstance soundInstance;
    protected class_4224 channel = null;
    protected boolean looping = false;
    protected int volume = 100;
    protected class_3419 soundSource;

    public AudioClip(@NotNull class_2960 soundLocation, @NotNull SoundType soundType) throws NullPointerException, InvalidAudioException {
        this(soundLocation, soundType, null);
    }

    public AudioClip(@NotNull class_2960 soundLocation, @NotNull SoundType soundType, @Nullable class_3419 soundSource) throws NullPointerException, InvalidAudioException {
        if (soundLocation == null) {
            throw new NullPointerException("Sound location is NULL!");
        }
        if (soundType == null) {
            throw new NullPointerException("Sound type is NULL!");
        }
        if (soundLocation instanceof ExternalSoundResourceLocation && soundType == SoundType.INTERNAL_ASSET) {
            throw new InvalidAudioException("Trying to load an ExternalSoundResourceLocation as internal asset!");
        }
        if (!(soundLocation instanceof ExternalSoundResourceLocation) && soundType != SoundType.INTERNAL_ASSET) {
            throw new InvalidAudioException("Trying to load an internal asset ResourceLocation as external sound!");
        }
        if (soundLocation instanceof ExternalSoundResourceLocation && ((ExternalSoundResourceLocation)soundLocation).getSoundType() != soundType) {
            throw new InvalidAudioException("Sound type of external sound doesn't match clip sound type!");
        }
        this.soundLocation = soundLocation;
        this.soundType = soundType;
        this.soundSource = soundSource;
        if (this.soundSource == null) {
            this.soundSource = class_3419.field_15250;
        }
        this.prepare();
        AudioHandler.registerAudioClip(this);
    }

    public static AudioClip buildExternalClip(String soundPath, SoundType soundType, @Nullable class_3419 soundSource) throws InvalidAudioException, NullPointerException {
        return new AudioClip(new ExternalSoundResourceLocation(soundPath, soundType), soundType, soundSource);
    }

    public static AudioClip buildExternalClip(String soundPath, SoundType soundType) throws InvalidAudioException, NullPointerException {
        return AudioClip.buildExternalClip(soundPath, soundType, null);
    }

    public static AudioClip buildInternalClip(class_2960 soundLocation, @Nullable class_3419 soundSource) throws InvalidAudioException, NullPointerException {
        return new AudioClip(soundLocation, SoundType.INTERNAL_ASSET, soundSource);
    }

    public static AudioClip buildInternalClip(class_2960 soundLocation) throws InvalidAudioException, NullPointerException {
        return AudioClip.buildInternalClip(soundLocation, class_3419.field_15250);
    }

    public boolean prepare() {
        try {
            this.stop();
            this.channel = null;
            if (this.soundType == SoundType.EXTERNAL_LOCAL || this.soundType == SoundType.EXTERNAL_WEB) {
                this.soundInstance = new AudioClipSoundInstance(this, this.soundLocation, this.soundSource, 1.0f, 1.0f);
                this.soundEvents = new class_1146(this.soundLocation, null);
                this.sound = new ExternalSound((ExternalSoundResourceLocation)this.soundLocation, 1.0f, 1.0f, 1, class_1111.class_1112.field_5474, false, 0);
                this.soundEvents.method_4885((class_1148)this.sound);
                VanillaSoundUtils.getSoundManagerRegistry().put(this.soundLocation, this.soundEvents);
                this.soundEvents.method_18188(VanillaSoundUtils.getSoundEngine());
                return true;
            }
            if (this.soundType == SoundType.INTERNAL_ASSET) {
                this.soundInstance = new AudioClipSoundInstance(this, this.soundLocation, this.soundSource, 1.0f, 1.0f);
                this.soundEvents = new class_1146(this.soundLocation, null);
                this.sound = new AudioClipSound(this.soundLocation, 1.0f, 1.0f, 1, class_1111.class_1112.field_5474, false, false, 0);
                this.soundEvents.method_4885((class_1148)this.sound);
                VanillaSoundUtils.getSoundManagerRegistry().put(this.soundLocation, this.soundEvents);
                this.soundEvents.method_18188(VanillaSoundUtils.getSoundEngine());
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public void play() {
        if (!this.playing()) {
            class_310.method_1551().method_1483().method_4873((class_1113)this.soundInstance);
            this.channel = VanillaSoundUtils.getChannelOfInstance((class_1113)this.soundInstance);
            AudioHandler.updateVolumes();
        }
    }

    public boolean stopped() {
        if (this.channel != null) {
            return this.channel.method_19656();
        }
        return true;
    }

    public void pause() {
        if (this.playing() && this.channel != null) {
            this.channel.method_19653();
        }
    }

    public boolean paused() {
        try {
            if (this.channel != null) {
                return AL10.alGetSourcei((int)this.getChannelSource(), (int)4112) == 4115;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public void unpause() {
        if (this.channel != null) {
            this.channel.method_19654();
        }
    }

    public void stop() {
        if (this.soundInstance != null) {
            class_310.method_1551().method_1483().method_4870((class_1113)this.soundInstance);
        }
        this.channel = null;
    }

    public boolean playing() {
        if (this.channel != null) {
            return this.channel.method_35598();
        }
        return false;
    }

    public void setLooping(boolean b) {
        this.looping = b;
    }

    public boolean isLooping() {
        return this.looping;
    }

    public void setVolume(int percentage) {
        if (percentage < 0) {
            percentage = 0;
        }
        if (percentage > 100) {
            percentage = 100;
        }
        this.volume = percentage;
        AudioHandler.updateVolumes();
    }

    public int getVolume() {
        return this.volume;
    }

    public void destroy() {
        this.stop();
        this.sound = null;
        this.soundInstance = null;
        this.soundEvents = null;
        this.soundLocation = null;
        AudioHandler.unregisterAudioClip(this);
    }

    public class_3419 getSoundSource() {
        return this.soundSource;
    }

    public String getSoundPath() {
        return this.soundLocation.method_12832();
    }

    public SoundType getSoundType() {
        return this.soundType;
    }

    public class_2960 getSoundLocation() {
        return this.soundLocation;
    }

    public AudioClipSoundInstance getSoundInstance() {
        return this.soundInstance;
    }

    public AudioClipSound getSound() {
        return this.sound;
    }

    public class_1146 getSoundEvents() {
        return this.soundEvents;
    }

    public int getChannelSource() {
        return ((IMixinChannel)this.channel).getSourceAuudio();
    }

    public static enum SoundType {
        EXTERNAL_WEB,
        EXTERNAL_LOCAL,
        INTERNAL_ASSET;

    }
}

