/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.auudio.audio;

import de.keksuccino.auudio.Auudio;
import de.keksuccino.auudio.audio.AudioClip;
import de.keksuccino.auudio.util.event.SubscribeEvent;
import de.keksuccino.auudio.util.event.events.ClientTickEvent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_4071;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AudioHandler {
    private static final Logger LOGGER = LogManager.getLogger((String)"auudio/AudioHandler");
    private static List<AudioClip> clips = new ArrayList<AudioClip>();
    private static List<AudioClip> wasPlayingLastTick = new ArrayList<AudioClip>();
    public static List<Runnable> postReloadingTasks = new ArrayList<Runnable>();
    private static boolean reloaded = false;
    protected static class_4071 lastOverlay = null;

    public static void init() {
        Auudio.EVENT_HANDLER.registerEventsFrom(new AudioHandler());
        LOGGER.info("Initialized!");
    }

    public static void registerAudioClip(AudioClip clip) {
        if (!clips.contains(clip)) {
            clips.add(clip);
        }
    }

    public static void unregisterAudioClip(AudioClip clip) {
        if (clips.contains(clip)) {
            clip.destroy();
        }
    }

    public static void updateVolumes() {
        class_310.method_1551().method_1483().method_4865(class_3419.field_15250, class_310.method_1551().field_1690.method_1630(class_3419.field_15250));
    }

    @SubscribeEvent
    public void onClientTick(ClientTickEvent e) {
        for (AudioClip c : clips) {
            if (c.isLooping() && wasPlayingLastTick.contains(c) && !c.playing() && c.channel != null && !c.paused()) {
                c.stop();
                c.play();
            }
            if (!c.playing()) {
                wasPlayingLastTick.remove(c);
                continue;
            }
            if (wasPlayingLastTick.contains(c)) continue;
            wasPlayingLastTick.add(c);
        }
        if (lastOverlay != null && class_310.method_1551().method_18506() == null) {
            LOGGER.info("Reloading sounds!");
            for (AudioClip c : clips) {
                c.prepare();
            }
            reloaded = true;
        } else if (reloaded) {
            LOGGER.info("Running post-reload tasks..");
            for (Runnable r : postReloadingTasks) {
                r.run();
            }
            reloaded = false;
        }
        lastOverlay = class_310.method_1551().method_18506();
    }
}

