/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.auudio.mixin.client;

import de.keksuccino.auudio.audio.AudioClip;
import de.keksuccino.auudio.audio.AudioClipInputStream;
import de.keksuccino.auudio.audio.exceptions.InvalidAudioException;
import de.keksuccino.auudio.audio.external.ExternalSoundResourceLocation;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_4228;
import net.minecraft.class_4234;
import net.minecraft.class_4237;
import net.minecraft.class_4856;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_4237.class})
public class MixinSoundBufferLibrary {
    private static final Logger MIXIN_LOGGER = LogManager.getLogger((String)"auudio/mixin/SoundBufferLibrary");

    @Inject(at={@At(value="HEAD")}, method={"getStream"}, cancellable=true)
    private void onGetStream(class_2960 location, boolean loop, CallbackInfoReturnable<CompletableFuture<class_4234>> info) {
        if (location instanceof ExternalSoundResourceLocation) {
            AudioClip.SoundType locationSoundType = ((ExternalSoundResourceLocation)location).getSoundType();
            info.setReturnValue(CompletableFuture.supplyAsync(() -> {
                try {
                    InputStream inputstream = null;
                    if (locationSoundType == AudioClip.SoundType.EXTERNAL_WEB) {
                        URL u = new URL(location.method_12832());
                        HttpURLConnection http = (HttpURLConnection)u.openConnection();
                        http.addRequestProperty("User-Agent", "Mozilla/4.0");
                        inputstream = new AudioClipInputStream(http.getInputStream(), location.method_12832(), AudioClip.SoundType.EXTERNAL_WEB);
                    } else if (locationSoundType == AudioClip.SoundType.EXTERNAL_LOCAL) {
                        File f = new File(location.method_12832());
                        if (f.isFile() && f.getPath().toLowerCase().endsWith(".ogg")) {
                            inputstream = new FileInputStream(f);
                        } else {
                            throw new InvalidAudioException("File not found or not a valid OGG file!");
                        }
                    }
                    if (inputstream != null) {
                        return loop ? new class_4856(class_4228::new, inputstream) : new class_4228(inputstream);
                    }
                    throw new NullPointerException("Unable to get input stream for sound! Input stream is NULL!");
                }
                catch (Exception ex) {
                    MIXIN_LOGGER.error("Error while trying to get input stream for external sound! (" + locationSoundType.name() + ")");
                    throw new CompletionException(ex);
                }
            }, class_156.method_18349()));
        }
    }
}

