/*
 * Decompiled with CFR 0.152.
 */
package com.nhoryzon.mc.farmersdelight.block;

import com.nhoryzon.mc.farmersdelight.entity.block.SkilletBlockEntity;
import com.nhoryzon.mc.farmersdelight.registry.BlockEntityTypesRegistry;
import com.nhoryzon.mc.farmersdelight.registry.SoundsRegistry;
import com.nhoryzon.mc.farmersdelight.registry.TagsRegistry;
import java.util.Random;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3614;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;

public class SkilletBlock
extends class_2237 {
    public static final int MINIMUM_COOKING_TIME = 60;
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_2746 SUPPORT = class_2746.method_11825((String)"support");
    protected static final class_265 SHAPE = class_2248.method_9541((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)4.0, (double)15.0);
    protected static final class_265 SHAPE_WITH_TRAY = class_259.method_1084((class_265)SHAPE, (class_265)class_2248.method_9541((double)0.0, (double)-1.0, (double)0.0, (double)16.0, (double)0.0, (double)16.0));

    public SkilletBlock() {
        super((class_4970.class_2251)FabricBlockSettings.of((class_3614)class_3614.field_15953).strength(0.5f, 6.0f).sounds(class_2498.field_17734));
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)SUPPORT, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return BlockEntityTypesRegistry.SKILLET.get().method_11032(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        if (world.method_8608()) {
            return SkilletBlock.method_31618(type, BlockEntityTypesRegistry.SKILLET.get(), SkilletBlockEntity::animationTick);
        }
        return SkilletBlock.method_31618(type, BlockEntityTypesRegistry.SKILLET.get(), SkilletBlockEntity::cookingTick);
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof SkilletBlockEntity) {
            SkilletBlockEntity skilletBlockEntity = (SkilletBlockEntity)blockEntity;
            if (!world.method_8608()) {
                class_1304 heldSlot;
                class_1799 heldStack = player.method_5998(hand);
                class_1304 class_13042 = heldSlot = hand == class_1268.field_5808 ? class_1304.field_6173 : class_1304.field_6171;
                if (heldStack.method_7960()) {
                    class_1799 extractedStack = skilletBlockEntity.removeItem();
                    if (!player.method_7337()) {
                        player.method_5673(heldSlot, extractedStack);
                    }
                    return class_1269.field_5812;
                }
                class_1799 remainderStack = skilletBlockEntity.addItemToCook(heldStack, player);
                if (remainderStack.method_7947() != heldStack.method_7947()) {
                    if (!player.method_7337()) {
                        player.method_5673(heldSlot, remainderStack);
                    }
                    world.method_8396(null, pos, class_3417.field_17743, class_3419.field_15245, 0.7f, 1.0f);
                    return class_1269.field_5812;
                }
            }
            return class_1269.field_21466;
        }
        return class_1269.field_5811;
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (state.method_26204() != newState.method_26204()) {
            class_2586 class_25862 = world.method_8321(pos);
            if (class_25862 instanceof SkilletBlockEntity) {
                SkilletBlockEntity skilletBlockEntity = (SkilletBlockEntity)class_25862;
                class_1264.method_5451((class_1937)world, (class_2338)pos, (class_1263)skilletBlockEntity.getInventory());
            }
            super.method_9536(state, world, pos, newState, moved);
        }
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{FACING, SUPPORT});
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)context.method_8042())).method_11657((class_2769)SUPPORT, (Comparable)Boolean.valueOf(this.getTrayState((class_1936)context.method_8045(), context.method_8037())));
    }

    public class_1799 method_9574(class_1922 world, class_2338 pos, class_2680 state) {
        class_1799 stack = super.method_9574(world, pos, state);
        SkilletBlockEntity skilletEntity = (SkilletBlockEntity)world.method_8321(pos);
        class_2487 nbt = new class_2487();
        if (skilletEntity != null) {
            skilletEntity.writeSkilletItem(nbt);
        }
        if (!nbt.method_33133()) {
            stack = class_1799.method_7915((class_2487)nbt.method_10562("Skillet"));
        }
        return stack;
    }

    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, Random random) {
        SkilletBlockEntity skilletBlockEntity;
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof SkilletBlockEntity && (skilletBlockEntity = (SkilletBlockEntity)blockEntity).isCooking()) {
            double x = (double)pos.method_10263() + 0.5;
            double y = pos.method_10264();
            double z = (double)pos.method_10260() + 0.5;
            if (random.nextInt(10) == 0) {
                world.method_8486(x, y, z, SoundsRegistry.BLOCK_SKILLET_SIZZLE.get(), class_3419.field_15245, 0.4f, random.nextFloat() * 0.2f + 0.9f, false);
            }
        }
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return Boolean.TRUE.equals(state.method_11654((class_2769)SUPPORT)) ? SHAPE_WITH_TRAY : SHAPE;
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)FACING)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654((class_2769)FACING)));
    }

    private boolean getTrayState(class_1936 worldAccess, class_2338 pos) {
        return worldAccess.method_8320(pos.method_10074()).method_26164(TagsRegistry.TRAY_HEAT_SOURCES);
    }

    public static int getSkilletCookingTime(int originalCookingTime, int fireAspectLevel) {
        int cookingTime = originalCookingTime > 0 ? originalCookingTime : 600;
        int cookingSeconds = cookingTime / 20;
        float cookingTimeReduction = 0.2f;
        if (fireAspectLevel > 0) {
            cookingTimeReduction = (float)((double)cookingTimeReduction - (double)fireAspectLevel * 0.05);
        }
        int result = (int)((float)cookingSeconds * cookingTimeReduction) * 20;
        return class_3532.method_15340((int)result, (int)60, (int)originalCookingTime);
    }
}

