/*
 * Decompiled with CFR 0.152.
 */
package dev.loleq21.gearreborn;

import dev.loleq21.gearreborn.GRConfig;
import dev.loleq21.gearreborn.GRContent;
import dev.loleq21.gearreborn.GearReborn;
import dev.loleq21.gearreborn.HazmatSuitUtils;
import java.util.List;
import me.sargunvohra.mcmods.autoconfig1u.AutoConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3611;
import org.jetbrains.annotations.Nullable;
import reborncore.api.items.ArmorBlockEntityTicker;
import reborncore.api.items.ArmorRemoveHandler;
import reborncore.common.powerSystem.RcEnergyItem;
import reborncore.common.powerSystem.RcEnergyTier;
import reborncore.common.util.ItemUtils;
import techreborn.init.TRContent;
import techreborn.utils.InitUtils;

public class HazmatChestPiece
extends class_1738
implements ArmorBlockEntityTicker,
RcEnergyItem,
ArmorRemoveHandler {
    GRConfig config = (GRConfig)AutoConfig.getConfigHolder(GRConfig.class).getConfig();
    public final int airCapacity;
    public final long energyCapacity;
    public final long coolingEnergyCost;

    public HazmatChestPiece(class_1741 material, class_1304 slot) {
        super(material, slot, new class_1792.class_1793().method_7892(GearReborn.ITEMGROUP).method_7889(1).method_24359().method_7895(-1));
        this.airCapacity = this.config.hazmatChestpieceAirTicksCapacity;
        this.energyCapacity = this.config.hazmatChestpieceEnergyCapacity;
        this.coolingEnergyCost = this.config.hazmatChestpieceLavaCoolingEnergyCost;
    }

    public void tickArmor(class_1799 itemStack, class_1657 playerEntity) {
        if (playerEntity.method_5770().method_8608()) {
            return;
        }
        if (!HazmatSuitUtils.playerIsWearingChestAndHelm(playerEntity)) {
            return;
        }
        if (this.getStoredAir(itemStack) == 0) {
            for (int i = 0; i < playerEntity.method_31548().method_5439(); ++i) {
                class_1799 iteratedStack = playerEntity.method_31548().method_5438(i);
                if (iteratedStack.method_7909() != TRContent.CELL || TRContent.CELL.getFluid(iteratedStack) != (class_3611)class_2378.field_11154.method_10223(new class_2960("techreborn:compressed_air"))) continue;
                iteratedStack.method_7934(1);
                class_1799 emptyCell = new class_1799((class_1935)TRContent.CELL, 1);
                playerEntity.method_7270(emptyCell);
                this.setStoredAir(itemStack, this.airCapacity);
                class_1937 world = playerEntity.method_5770();
                world.method_8396(null, playerEntity.method_24515(), class_3417.field_14883, class_3419.field_15254, 0.8f, 1.0f + (world.field_9229.nextFloat() - world.field_9229.nextFloat()) * 0.4f);
            }
        }
        if (playerEntity.method_5869()) {
            if (this.useStoredAir(itemStack, 1)) {
                playerEntity.method_6092(new class_1293(class_1294.field_5923, 999999, 0, false, false, false));
            } else {
                this.disableWaterBreathing(playerEntity);
            }
        } else {
            this.disableWaterBreathing(playerEntity);
        }
        if (!HazmatSuitUtils.playerIsWearingFullHazmat(playerEntity)) {
            this.disableFireResist(playerEntity);
            return;
        }
        if (!playerEntity.method_5771()) {
            playerEntity.method_6092(new class_1293(class_1294.field_5918, 999999, 0, false, false, false));
        } else if (this.tryUseEnergy(itemStack, this.coolingEnergyCost)) {
            playerEntity.method_6092(new class_1293(class_1294.field_5918, 999999, 0, false, false, false));
        } else {
            this.disableFireResist(playerEntity);
        }
        if (playerEntity.method_5809() && this.getStoredEnergy(itemStack) >= this.coolingEnergyCost * 2L) {
            playerEntity.method_5646();
        }
    }

    private void disableFireResist(class_1657 playerEntity) {
        if (!playerEntity.method_5770().method_8608()) {
            playerEntity.method_6016(class_1294.field_5918);
        }
    }

    private void disableWaterBreathing(class_1657 playerEntity) {
        if (!playerEntity.method_5770().method_8608()) {
            playerEntity.method_6016(class_1294.field_5923);
        }
    }

    private void removeEffects(class_1657 playerEntity) {
        if (!playerEntity.method_5770().method_8608()) {
            playerEntity.method_6016(class_1294.field_5918);
            playerEntity.method_6016(class_1294.field_5923);
        }
    }

    public int getStoredAir(class_1799 stack) {
        if (stack.method_7909() == GRContent.HAZMAT_CHESTPIECE) {
            this.validateAirNbtTag(stack);
            return stack.method_7969().method_10550("air");
        }
        return 0;
    }

    public void setStoredAir(class_1799 stack, int amount) {
        if (stack.method_7909() == GRContent.HAZMAT_CHESTPIECE) {
            this.validateAirNbtTag(stack);
            stack.method_7969().method_10569("air", amount);
        }
    }

    public boolean useStoredAir(class_1799 stack, int amount) {
        if (stack.method_7909() == GRContent.HAZMAT_CHESTPIECE) {
            this.validateAirNbtTag(stack);
            if (this.getStoredAir(stack) >= amount) {
                this.setStoredAir(stack, this.getStoredAir(stack) - amount);
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean addStoredAir(class_1799 stack, int amount) {
        if (stack.method_7909() == GRContent.HAZMAT_CHESTPIECE) {
            this.validateAirNbtTag(stack);
            if (this.getStoredAir(stack) + amount > this.airCapacity) {
                return false;
            }
            this.setStoredAir(stack, this.getStoredAir(stack) + amount);
            return true;
        }
        return false;
    }

    public int getAirCapacity() {
        return this.airCapacity;
    }

    private void validateAirNbtTag(class_1799 stack) {
        GRConfig config = (GRConfig)AutoConfig.getConfigHolder(GRConfig.class).getConfig();
        if (!stack.method_7948().method_10573("air", 3)) {
            stack.method_7969().method_10569("air", 0);
            return;
        }
        if (stack.method_7969().method_10550("air") > config.hazmatChestpieceAirTicksCapacity) {
            stack.method_7969().method_10569("air", config.hazmatChestpieceAirTicksCapacity);
        }
    }

    public int getStoredAir4ToolTip(class_1799 stack) {
        if (stack.method_7985()) {
            return stack.method_7969().method_10550("air");
        }
        return 0;
    }

    public boolean method_7870(class_1799 stack) {
        return false;
    }

    public long getEnergyCapacity() {
        return this.energyCapacity;
    }

    public RcEnergyTier getTier() {
        return RcEnergyTier.MEDIUM;
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, @Nullable class_1937 worldIn, List<class_2561> tooltip, class_1836 flagIn) {
        class_2585 line1 = new class_2585(String.valueOf(this.getStoredAir4ToolTip(stack) * 100 / this.airCapacity));
        line1.method_27693("%");
        line1.method_27693(" ");
        line1.method_10852((class_2561)new class_2588("gearreborn.misc.hazmatairpressure"));
        line1.method_27692(class_124.field_1075);
        tooltip.add(1, (class_2561)line1);
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7850(class_1761 group, class_2371<class_1799> itemList) {
        if (!this.method_7877(group)) {
            return;
        }
        InitUtils.initPoweredItems((class_1792)this, itemList);
    }

    public int method_31569(class_1799 stack) {
        return ItemUtils.getPowerForDurabilityBar((class_1799)stack);
    }

    public boolean method_31567(class_1799 stack) {
        return true;
    }

    public int method_31571(class_1799 stack) {
        return ItemUtils.getColorForDurabilityBar((class_1799)stack);
    }

    public void onRemoved(class_1657 playerEntity) {
        this.removeEffects(playerEntity);
    }

    public boolean method_7846() {
        return false;
    }
}

