/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft;

import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.detail.IDetailProvider;
import dan200.computercraft.api.filesystem.IMount;
import dan200.computercraft.api.filesystem.IWritableMount;
import dan200.computercraft.api.lua.GenericSource;
import dan200.computercraft.api.lua.ILuaAPIFactory;
import dan200.computercraft.api.media.IMediaProvider;
import dan200.computercraft.api.network.IPacketNetwork;
import dan200.computercraft.api.network.wired.IWiredElement;
import dan200.computercraft.api.network.wired.IWiredNode;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.redstone.IBundledRedstoneProvider;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.core.apis.ApiFactories;
import dan200.computercraft.core.asm.GenericMethod;
import dan200.computercraft.core.filesystem.FileMount;
import dan200.computercraft.core.filesystem.ResourceMount;
import dan200.computercraft.shared.BundledRedstone;
import dan200.computercraft.shared.MediaProviders;
import dan200.computercraft.shared.Peripherals;
import dan200.computercraft.shared.PocketUpgrades;
import dan200.computercraft.shared.TurtleUpgrades;
import dan200.computercraft.shared.peripheral.generic.data.DetailProviders;
import dan200.computercraft.shared.peripheral.modem.wired.TileCable;
import dan200.computercraft.shared.peripheral.modem.wired.TileWiredModemFull;
import dan200.computercraft.shared.peripheral.modem.wireless.WirelessNetwork;
import dan200.computercraft.shared.util.IDAssigner;
import dan200.computercraft.shared.wired.WiredNode;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.shedaniel.cloth.api.utils.v1.GameInstanceUtils;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3300;

public final class ComputerCraftAPIImpl
implements ComputerCraftAPI.IComputerCraftAPI {
    public static final ComputerCraftAPIImpl INSTANCE = new ComputerCraftAPIImpl();
    private String version;

    private ComputerCraftAPIImpl() {
    }

    public static InputStream getResourceFile(String domain, String subPath) {
        class_3300 manager = GameInstanceUtils.getServer().method_34864();
        try {
            return manager.method_14486(new class_2960(domain, subPath)).method_14482();
        }
        catch (IOException ignored) {
            return null;
        }
    }

    @Override
    @Nonnull
    public String getInstalledVersion() {
        if (this.version != null) {
            return this.version;
        }
        this.version = FabricLoader.getInstance().getModContainer("computercraft").map(x -> x.getMetadata().getVersion().toString()).orElse("unknown");
        return this.version;
    }

    @Override
    public int createUniqueNumberedSaveDir(@Nonnull class_1937 world, @Nonnull String parentSubPath) {
        return IDAssigner.getNextId(parentSubPath);
    }

    @Override
    public IWritableMount createSaveDirMount(@Nonnull class_1937 world, @Nonnull String subPath, long capacity) {
        try {
            return new FileMount(new File(IDAssigner.getDir(), subPath), capacity);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public IMount createResourceMount(@Nonnull String domain, @Nonnull String subPath) {
        class_3300 manager = GameInstanceUtils.getServer().method_34864();
        ResourceMount mount = ResourceMount.get(domain, subPath, manager);
        return mount.exists("") ? mount : null;
    }

    @Override
    public void registerPeripheralProvider(@Nonnull IPeripheralProvider provider) {
        Peripherals.register(provider);
    }

    @Override
    public void registerGenericSource(@Nonnull GenericSource source) {
        GenericMethod.register(source);
    }

    @Override
    public void registerTurtleUpgrade(@Nonnull ITurtleUpgrade upgrade) {
        TurtleUpgrades.register(upgrade);
    }

    @Override
    public void registerPocketUpgrade(@Nonnull IPocketUpgrade upgrade) {
        PocketUpgrades.register(upgrade);
    }

    @Override
    public void registerBundledRedstoneProvider(@Nonnull IBundledRedstoneProvider provider) {
        BundledRedstone.register(provider);
    }

    @Override
    public int getBundledRedstoneOutput(@Nonnull class_1937 world, @Nonnull class_2338 pos, @Nonnull class_2350 side) {
        return BundledRedstone.getDefaultOutput(world, pos, side);
    }

    @Override
    public void registerMediaProvider(@Nonnull IMediaProvider provider) {
        MediaProviders.register(provider);
    }

    @Override
    @Nonnull
    public IPacketNetwork getWirelessNetwork() {
        return WirelessNetwork.getUniversal();
    }

    @Override
    public void registerAPIFactory(@Nonnull ILuaAPIFactory factory) {
        ApiFactories.register(factory);
    }

    @Override
    public <T> void registerDetailProvider(@Nonnull Class<T> type, @Nonnull IDetailProvider<T> provider) {
        DetailProviders.registerProvider(type, provider);
    }

    @Override
    @Nonnull
    public IWiredNode createWiredNodeForElement(@Nonnull IWiredElement element) {
        return new WiredNode(element);
    }

    @Override
    @Nullable
    public IWiredElement getWiredElementAt(@Nonnull class_1922 world, @Nonnull class_2338 pos, @Nonnull class_2350 side) {
        class_2586 tile = world.method_8321(pos);
        if (tile instanceof TileCable) {
            return ((TileCable)tile).getElement(side);
        }
        if (tile instanceof TileWiredModemFull) {
            return ((TileWiredModemFull)tile).getElement();
        }
        return null;
    }
}

