/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.proxy;

import dan200.computercraft.client.ClientRegistry;
import dan200.computercraft.client.FrameInfo;
import dan200.computercraft.client.gui.GuiComputer;
import dan200.computercraft.client.gui.GuiDiskDrive;
import dan200.computercraft.client.gui.GuiPrinter;
import dan200.computercraft.client.gui.GuiPrintout;
import dan200.computercraft.client.gui.GuiTurtle;
import dan200.computercraft.client.gui.NoTermComputerScreen;
import dan200.computercraft.client.render.TileEntityMonitorRenderer;
import dan200.computercraft.client.render.TileEntityTurtleRenderer;
import dan200.computercraft.client.render.TurtleModelLoader;
import dan200.computercraft.client.sound.SpeakerManager;
import dan200.computercraft.fabric.events.CustomClientEvents;
import dan200.computercraft.shared.Registry;
import dan200.computercraft.shared.common.IColouredItem;
import dan200.computercraft.shared.common.TileGeneric;
import dan200.computercraft.shared.peripheral.monitor.ClientMonitor;
import dan200.computercraft.shared.pocket.items.ItemPocketComputer;
import dan200.computercraft.shared.util.Config;
import dan200.computercraft.shared.util.PauseAwareTimer;
import java.util.function.Supplier;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientBlockEntityEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.model.ModelLoadingRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.BlockEntityRendererRegistry;
import net.fabricmc.fabric.api.event.client.ClientSpriteRegistryCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1309;
import net.minecraft.class_1723;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3929;
import net.minecraft.class_5272;
import net.minecraft.class_638;
import net.minecraft.class_6395;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public final class ComputerCraftProxyClient
implements ClientModInitializer {
    private static void initEvents() {
        ClientBlockEntityEvents.BLOCK_ENTITY_UNLOAD.register((blockEntity, world) -> {
            if (blockEntity instanceof TileGeneric) {
                ((TileGeneric)blockEntity).onChunkUnloaded();
            }
        });
        ServerTickEvents.START_SERVER_TICK.register(server -> PauseAwareTimer.tick());
        CustomClientEvents.CLIENT_UNLOAD_WORLD_EVENT.register(() -> {
            SpeakerManager.reset();
            ClientMonitor.destroyAll();
        });
        CustomClientEvents.PLAY_STREAMING_AUDIO_EVENT.register(SpeakerManager::playStreaming);
        ClientLifecycleEvents.CLIENT_STARTED.register(Config::clientStarted);
    }

    public void onInitializeClient() {
        FrameInfo.init();
        ComputerCraftProxyClient.registerContainers();
        BlockRenderLayerMap.INSTANCE.putBlock((class_2248)Registry.ModBlocks.TURTLE_NORMAL, class_1921.method_23583());
        BlockRenderLayerMap.INSTANCE.putBlock((class_2248)Registry.ModBlocks.TURTLE_ADVANCED, class_1921.method_23583());
        BlockRenderLayerMap.INSTANCE.putBlock((class_2248)Registry.ModBlocks.MONITOR_NORMAL, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock((class_2248)Registry.ModBlocks.MONITOR_ADVANCED, class_1921.method_23581());
        BlockEntityRendererRegistry.register(Registry.ModBlockEntities.MONITOR_NORMAL, TileEntityMonitorRenderer::new);
        BlockEntityRendererRegistry.register(Registry.ModBlockEntities.MONITOR_ADVANCED, TileEntityMonitorRenderer::new);
        BlockEntityRendererRegistry.register(Registry.ModBlockEntities.TURTLE_NORMAL, TileEntityTurtleRenderer::new);
        BlockEntityRendererRegistry.register(Registry.ModBlockEntities.TURTLE_ADVANCED, TileEntityTurtleRenderer::new);
        ClientSpriteRegistryCallback.event((class_2960)class_1723.field_21668).register(ClientRegistry::onTextureStitchEvent);
        ModelLoadingRegistry.INSTANCE.registerModelProvider(ClientRegistry::onModelBakeEvent);
        ModelLoadingRegistry.INSTANCE.registerResourceProvider(loader -> (name, context) -> TurtleModelLoader.INSTANCE.accepts(name) ? TurtleModelLoader.INSTANCE.loadModel(name) : null);
        ComputerCraftProxyClient.registerItemProperty("state", (stack, world, player, integer) -> ItemPocketComputer.getState(stack).ordinal(), () -> Registry.ModItems.POCKET_COMPUTER_NORMAL, () -> Registry.ModItems.POCKET_COMPUTER_ADVANCED);
        ComputerCraftProxyClient.registerItemProperty("coloured", (stack, world, player, integer) -> IColouredItem.getColourBasic(stack) != -1 ? 1.0f : 0.0f, () -> Registry.ModItems.POCKET_COMPUTER_NORMAL, () -> Registry.ModItems.POCKET_COMPUTER_ADVANCED);
        ClientRegistry.onItemColours();
        ComputerCraftProxyClient.initEvents();
    }

    private static void registerContainers() {
        class_3929.method_17542(Registry.ModContainers.COMPUTER, GuiComputer::create);
        class_3929.method_17542(Registry.ModContainers.POCKET_COMPUTER, GuiComputer::createPocket);
        class_3929.method_17542(Registry.ModContainers.POCKET_COMPUTER_NO_TERM, NoTermComputerScreen::new);
        class_3929.method_17542(Registry.ModContainers.TURTLE, GuiTurtle::new);
        class_3929.method_17542(Registry.ModContainers.PRINTER, GuiPrinter::new);
        class_3929.method_17542(Registry.ModContainers.DISK_DRIVE, GuiDiskDrive::new);
        class_3929.method_17542(Registry.ModContainers.PRINTOUT, GuiPrintout::new);
        class_3929.method_17542(Registry.ModContainers.VIEW_COMPUTER, GuiComputer::createView);
    }

    @SafeVarargs
    private static void registerItemProperty(String name, final class_6395 getter, Supplier<? extends class_1792> ... items) {
        class_2960 id = new class_2960("computercraft", name);
        class_6395 unclampedGetter = new class_6395(){

            @Deprecated
            public float call(@NotNull class_1799 itemStack, @Nullable class_638 clientLevel, @Nullable class_1309 livingEntity, int i) {
                return getter.unclampedCall(itemStack, clientLevel, livingEntity, i);
            }

            public float unclampedCall(class_1799 itemStack, @Nullable class_638 clientLevel, @Nullable class_1309 livingEntity, int i) {
                return getter.unclampedCall(itemStack, clientLevel, livingEntity, i);
            }
        };
        for (Supplier<? extends class_1792> item : items) {
            class_5272.method_27879((class_1792)item.get(), (class_2960)id, (class_6395)unclampedGetter);
        }
    }
}

