/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import dan200.computercraft.shared.peripheral.generic.GenericPeripheralProvider;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;

public final class Peripherals {
    private static final Collection<IPeripheralProvider> providers = new LinkedHashSet<IPeripheralProvider>();

    private Peripherals() {
    }

    public static synchronized void register(@Nonnull IPeripheralProvider provider) {
        Objects.requireNonNull(provider, "provider cannot be null");
        providers.add(provider);
    }

    @Nullable
    public static IPeripheral getPeripheral(class_1937 world, class_2338 pos, class_2350 side) {
        return world.method_24794(pos) && !world.field_9236 ? Peripherals.getPeripheralAt(world, pos, side) : null;
    }

    @Nullable
    private static IPeripheral getPeripheralAt(class_1937 world, class_2338 pos, class_2350 side) {
        for (IPeripheralProvider peripheralProvider : providers) {
            try {
                IPeripheral peripheral = peripheralProvider.getPeripheral(world, pos, side);
                if (peripheral == null) continue;
                return peripheral;
            }
            catch (Exception e) {
                ComputerCraft.log.error("Peripheral provider " + peripheralProvider + " errored.", (Throwable)e);
            }
        }
        return GenericPeripheralProvider.getPeripheral(world, pos, side);
    }
}

