/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.command.builder;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import dan200.computercraft.shared.command.text.ChatHelpers;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_5250;

public final class HelpingArgumentBuilder
extends LiteralArgumentBuilder<class_2168> {
    private final Collection<HelpingArgumentBuilder> children = new ArrayList<HelpingArgumentBuilder>();
    private static final class_124 HEADER = class_124.field_1076;
    private static final class_124 SYNOPSIS = class_124.field_1075;
    private static final class_124 NAME = class_124.field_1060;

    private HelpingArgumentBuilder(String literal) {
        super(literal);
    }

    public static HelpingArgumentBuilder choice(String literal) {
        return new HelpingArgumentBuilder(literal);
    }

    public LiteralArgumentBuilder<class_2168> executes(Command<class_2168> command) {
        throw new IllegalStateException("Cannot use executes on a HelpingArgumentBuilder");
    }

    public LiteralArgumentBuilder<class_2168> then(ArgumentBuilder<class_2168, ?> argument) {
        if (this.getRedirect() != null) {
            throw new IllegalStateException("Cannot add children to a redirected node");
        }
        if (argument instanceof HelpingArgumentBuilder) {
            this.children.add((HelpingArgumentBuilder)argument);
        } else if (argument instanceof LiteralArgumentBuilder) {
            super.then(argument);
        } else {
            throw new IllegalStateException("HelpingArgumentBuilder can only accept literal children");
        }
        return this;
    }

    public LiteralArgumentBuilder<class_2168> then(CommandNode<class_2168> argument) {
        if (!(argument instanceof LiteralCommandNode)) {
            throw new IllegalStateException("HelpingArgumentBuilder can only accept literal children");
        }
        return (LiteralArgumentBuilder)super.then(argument);
    }

    public LiteralCommandNode<class_2168> build() {
        return this.buildImpl(this.getLiteral().replace('-', '_'), this.getLiteral());
    }

    private LiteralCommandNode<class_2168> build(@Nonnull String id, @Nonnull String command) {
        return this.buildImpl(id + "." + this.getLiteral().replace('-', '_'), command + " " + this.getLiteral());
    }

    private LiteralCommandNode<class_2168> buildImpl(String id, String command) {
        LiteralCommandNode node;
        HelpCommand helpCommand = new HelpCommand(id, command);
        helpCommand.node = node = new LiteralCommandNode(this.getLiteral(), (Command)helpCommand, this.getRequirement(), this.getRedirect(), this.getRedirectModifier(), this.isFork());
        LiteralArgumentBuilder helpNode = (LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"help").requires(x -> this.getArguments().stream().anyMatch(y -> y.getRequirement().test(x)))).executes((Command)helpCommand);
        for (CommandNode child : this.getArguments()) {
            node.addChild(child);
            helpNode.then((CommandNode)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)child.getName()).requires(child.getRequirement())).executes(HelpingArgumentBuilder.helpForChild((CommandNode<class_2168>)child, id, command))).build());
        }
        for (HelpingArgumentBuilder childBuilder : this.children) {
            LiteralCommandNode<class_2168> child = childBuilder.build(id, command);
            node.addChild(child);
            helpNode.then((CommandNode)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)child.getName()).requires(child.getRequirement())).executes(HelpingArgumentBuilder.helpForChild(child, id, command))).redirect(child.getChild("help"))).build());
        }
        node.addChild((CommandNode)helpNode.build());
        return node;
    }

    private static Command<class_2168> helpForChild(CommandNode<class_2168> node, String id, String command) {
        return context -> {
            ((class_2168)context.getSource()).method_9226(HelpingArgumentBuilder.getHelp((CommandContext<class_2168>)context, node, id + "." + node.getName().replace('-', '_'), command + " " + node.getName()), false);
            return 0;
        };
    }

    private static class_2561 getHelp(CommandContext<class_2168> context, CommandNode<class_2168> node, String id, String command) {
        CommandDispatcher dispatcher = ((class_2168)context.getSource()).method_9211().method_3734().method_9235();
        LiteralCommandNode temp = new LiteralCommandNode("_", null, x -> true, null, null, false);
        temp.addChild(node);
        String usage = ((String)dispatcher.getSmartUsage((CommandNode)temp, (Object)((class_2168)context.getSource())).get(node)).substring(node.getName().length());
        class_5250 output = new class_2585("").method_10852((class_2561)ChatHelpers.coloured("/" + command + usage, HEADER)).method_27693(" ").method_10852((class_2561)ChatHelpers.coloured(ChatHelpers.translate("commands." + id + ".synopsis"), SYNOPSIS)).method_27693("\n").method_10852((class_2561)ChatHelpers.translate("commands." + id + ".desc"));
        for (CommandNode child : node.getChildren()) {
            if (!child.getRequirement().test((class_2168)context.getSource()) || !(child instanceof LiteralCommandNode)) continue;
            output.method_27693("\n");
            class_5250 component = ChatHelpers.coloured(child.getName(), NAME);
            component.method_10866().method_10958(new class_2558(class_2558.class_2559.field_11745, "/" + command + " " + child.getName()));
            output.method_10852((class_2561)component);
            output.method_27693(" - ").method_10852((class_2561)ChatHelpers.translate("commands." + id + "." + child.getName() + ".synopsis"));
        }
        return output;
    }

    private static final class HelpCommand
    implements Command<class_2168> {
        private final String id;
        private final String command;
        LiteralCommandNode<class_2168> node;

        private HelpCommand(String id, String command) {
            this.id = id;
            this.command = command;
        }

        public int run(CommandContext<class_2168> context) {
            ((class_2168)context.getSource()).method_9226(HelpingArgumentBuilder.getHelp(context, this.node, this.id, this.command), false);
            return 0;
        }
    }
}

