/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.blocks;

import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.shared.common.BlockGeneric;
import dan200.computercraft.shared.common.IBundledRedstoneBlock;
import dan200.computercraft.shared.computer.blocks.IComputerTile;
import dan200.computercraft.shared.computer.blocks.TileComputerBase;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.items.IComputerItem;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3468;
import net.minecraft.class_47;
import net.minecraft.class_4970;
import net.minecraft.class_5558;

public abstract class BlockComputerBase<T extends TileComputerBase>
extends BlockGeneric
implements IBundledRedstoneBlock {
    private static final class_2960 DROP = new class_2960("computercraft", "computer");
    private final ComputerFamily family;
    protected final Supplier<class_2591<T>> type;
    private final class_5558<T> serverTicker = (level, pos, state, computer) -> computer.serverTick();

    protected BlockComputerBase(class_4970.class_2251 settings, ComputerFamily family, Supplier<class_2591<T>> type) {
        super(settings, type);
        this.family = family;
        this.type = type;
    }

    @Deprecated
    public void method_9615(@Nonnull class_2680 state, @Nonnull class_1937 world, @Nonnull class_2338 pos, @Nonnull class_2680 oldState, boolean isMoving) {
        super.method_9615(state, world, pos, oldState, isMoving);
        class_2586 tile = world.method_8321(pos);
        if (tile instanceof TileComputerBase) {
            TileComputerBase computer = (TileComputerBase)tile;
            computer.updateInputsImmediately();
        }
    }

    @Deprecated
    public boolean method_9506(@Nonnull class_2680 state) {
        return true;
    }

    @Deprecated
    public int method_9603(@Nonnull class_2680 state, class_1922 world, @Nonnull class_2338 pos, @Nonnull class_2350 incomingSide) {
        class_2586 entity = world.method_8321(pos);
        if (!(entity instanceof TileComputerBase)) {
            return 0;
        }
        TileComputerBase computerEntity = (TileComputerBase)entity;
        ServerComputer computer = computerEntity.getServerComputer();
        if (computer == null) {
            return 0;
        }
        ComputerSide localSide = computerEntity.remapToLocalSide(incomingSide.method_10153());
        return computer.getRedstoneOutput(localSide);
    }

    @Nonnull
    protected abstract class_1799 getItem(TileComputerBase var1);

    public ComputerFamily getFamily() {
        return this.family;
    }

    @Deprecated
    public int method_9524(@Nonnull class_2680 state, @Nonnull class_1922 world, @Nonnull class_2338 pos, @Nonnull class_2350 incomingSide) {
        return this.method_9603(state, world, pos, incomingSide);
    }

    @Override
    public boolean getBundledRedstoneConnectivity(class_1937 world, class_2338 pos, class_2350 side) {
        return true;
    }

    @Override
    public int getBundledRedstoneOutput(class_1937 world, class_2338 pos, class_2350 side) {
        class_2586 entity = world.method_8321(pos);
        if (!(entity instanceof TileComputerBase)) {
            return 0;
        }
        TileComputerBase computerEntity = (TileComputerBase)entity;
        ServerComputer computer = computerEntity.getServerComputer();
        if (computer == null) {
            return 0;
        }
        ComputerSide localSide = computerEntity.remapToLocalSide(side);
        return computer.getBundledRedstoneOutput(localSide);
    }

    @Nonnull
    public class_1799 method_9574(class_1922 world, class_2338 pos, class_2680 state) {
        class_1799 result;
        class_2586 tile = world.method_8321(pos);
        if (tile instanceof TileComputerBase && !(result = this.getItem((TileComputerBase)tile)).method_7960()) {
            return result;
        }
        return super.method_9574(world, pos, state);
    }

    public void method_9556(@Nonnull class_1937 world, class_1657 player, @Nonnull class_2338 pos, @Nonnull class_2680 state, @Nullable class_2586 tile, @Nonnull class_1799 tool) {
        player.method_7259(class_3468.field_15427.method_14956((Object)this));
        player.method_7322(0.005f);
    }

    public void method_9576(@Nonnull class_1937 world, @Nonnull class_2338 pos, @Nonnull class_2680 state, @Nonnull class_1657 player) {
        super.method_9576(world, pos, state, player);
        if (!(world instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        class_2586 tile = world.method_8321(pos);
        if (tile instanceof TileComputerBase) {
            TileComputerBase computer = (TileComputerBase)tile;
            class_47.class_48 context = new class_47.class_48(serverWorld).method_311(world.field_9229).method_312(class_181.field_24424, (Object)class_243.method_24953((class_2382)pos)).method_312(class_181.field_1229, (Object)player.method_6047()).method_312(class_181.field_1226, (Object)player).method_312(class_181.field_1228, (Object)tile).method_307(DROP, (ctx, out) -> out.accept(this.getItem(computer)));
            for (class_1799 item : state.method_26189(context)) {
                BlockComputerBase.method_9577((class_1937)world, (class_2338)pos, (class_1799)item);
            }
            state.method_26180(serverWorld, pos, player.method_6047());
        }
    }

    public void method_9567(@Nonnull class_1937 world, @Nonnull class_2338 pos, @Nonnull class_2680 state, class_1309 placer, @Nonnull class_1799 stack) {
        super.method_9567(world, pos, state, placer, stack);
        class_2586 tile = world.method_8321(pos);
        if (!world.field_9236 && tile instanceof IComputerTile) {
            IComputerTile computer = (IComputerTile)tile;
            class_1792 class_17922 = stack.method_7909();
            if (class_17922 instanceof IComputerItem) {
                String label;
                IComputerItem item = (IComputerItem)class_17922;
                int id = item.getComputerID(stack);
                if (id != -1) {
                    computer.setComputerID(id);
                }
                if ((label = item.getLabel(stack)) != null) {
                    computer.setLabel(label);
                }
            }
        }
    }

    @Nullable
    public <U extends class_2586> class_5558<U> method_31645(@Nonnull class_1937 level, @Nonnull class_2680 state, @Nonnull class_2591<U> type) {
        return level.field_9236 ? null : class_2237.method_31618(type, this.type.get(), this.serverTicker);
    }
}

