/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.recipe;

import com.google.gson.JsonObject;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.recipe.ComputerConvertRecipe;
import dan200.computercraft.shared.util.RecipeUtil;
import javax.annotation.Nonnull;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public abstract class ComputerFamilyRecipe
extends ComputerConvertRecipe {
    private final ComputerFamily family;

    public ComputerFamilyRecipe(class_2960 identifier, String group, int width, int height, class_2371<class_1856> ingredients, class_1799 result, ComputerFamily family) {
        super(identifier, group, width, height, ingredients, result);
        this.family = family;
    }

    public ComputerFamily getFamily() {
        return this.family;
    }

    public static abstract class Serializer<T extends ComputerFamilyRecipe>
    implements class_1865<T> {
        protected abstract T create(class_2960 var1, String var2, int var3, int var4, class_2371<class_1856> var5, class_1799 var6, ComputerFamily var7);

        @Nonnull
        public T fromJson(@Nonnull class_2960 identifier, @Nonnull JsonObject json) {
            String group = class_3518.method_15253((JsonObject)json, (String)"group", (String)"");
            ComputerFamily family = RecipeUtil.getFamily(json, "family");
            RecipeUtil.ShapedTemplate template = RecipeUtil.getTemplate(json);
            class_1799 result = class_1869.method_35228((JsonObject)class_3518.method_15296((JsonObject)json, (String)"result"));
            return this.create(identifier, group, template.width, template.height, template.ingredients, result, family);
        }

        @Nonnull
        public T fromNetwork(@Nonnull class_2960 identifier, @Nonnull class_2540 buf) {
            int width = buf.method_10816();
            int height = buf.method_10816();
            String group = buf.method_10800(Short.MAX_VALUE);
            class_2371 ingredients = class_2371.method_10213((int)(width * height), (Object)class_1856.field_9017);
            for (int i = 0; i < ingredients.size(); ++i) {
                ingredients.set(i, (Object)class_1856.method_8086((class_2540)buf));
            }
            class_1799 result = buf.method_10819();
            ComputerFamily family = (ComputerFamily)buf.method_10818(ComputerFamily.class);
            return this.create(identifier, group, width, height, (class_2371<class_1856>)ingredients, result, family);
        }

        public void toNetwork(@Nonnull class_2540 buf, @Nonnull T recipe) {
            buf.method_10804(recipe.method_8150());
            buf.method_10804(recipe.method_8158());
            buf.method_10814(((ComputerConvertRecipe)((Object)recipe)).method_8112());
            for (class_1856 ingredient : recipe.method_8117()) {
                ingredient.method_8088(buf);
            }
            buf.method_10793(recipe.method_8110());
            buf.method_10817((Enum)((ComputerFamilyRecipe)((Object)recipe)).getFamily());
        }
    }
}

