/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.integration;

import dan200.computercraft.client.render.RenderTypes;
import dan200.computercraft.client.render.text.DirectFixedWidthFontRenderer;
import java.nio.ByteBuffer;
import java.util.function.IntFunction;
import net.fabricmc.loader.api.FabricLoader;
import net.irisshaders.iris.api.v0.IrisApi;
import net.irisshaders.iris.api.v0.IrisTextVertexSink;
import net.minecraft.class_293;

public class IrisCompat {
    public static final IrisCompat INSTANCE = FabricLoader.getInstance().isModLoaded("iris") ? new Impl() : new IrisCompat();

    public boolean isRenderingShadowPass() {
        return false;
    }

    public DirectFixedWidthFontRenderer.QuadSink getVertexSink(int vertexCount, IntFunction<ByteBuffer> makeBuffer) {
        return new DirectFixedWidthFontRenderer.ByteBufferSink(makeBuffer.apply(RenderTypes.MONITOR.method_23031().method_1362() * vertexCount * 4));
    }

    private static class Impl
    extends IrisCompat {
        private Impl() {
        }

        @Override
        public boolean isRenderingShadowPass() {
            return IrisApi.getInstance().isRenderingShadowPass();
        }

        @Override
        public DirectFixedWidthFontRenderer.QuadSink getVertexSink(int vertexCount, IntFunction<ByteBuffer> makeBuffer) {
            return IrisApi.getInstance().getMinorApiRevision() >= 1 ? new IrisQuadSink(vertexCount, makeBuffer) : super.getVertexSink(vertexCount, makeBuffer);
        }
    }

    private static final class IrisQuadSink
    implements DirectFixedWidthFontRenderer.QuadSink {
        private final IrisTextVertexSink sink;

        private IrisQuadSink(int vertexCount, IntFunction<ByteBuffer> makeBuffer) {
            this.sink = IrisApi.getInstance().createTextVertexSink(vertexCount, makeBuffer);
        }

        @Override
        public class_293 getFormat() {
            return this.sink.getUnderlyingVertexFormat();
        }

        @Override
        public ByteBuffer buffer() {
            return this.sink.getUnderlyingByteBuffer();
        }

        @Override
        public void quad(float x1, float y1, float x2, float y2, float z, byte[] rgba, float u1, float v1, float u2, float v2) {
            this.sink.quad(x1, y1, x2, y2, z, IrisQuadSink.pack(rgba[0], rgba[1], rgba[2], rgba[3]), u1, v1, u2, v2, 0xF000F0);
        }

        private static int pack(int r, int g, int b, int a) {
            return (a & 0xFF) << 24 | (b & 0xFF) << 16 | (g & 0xFF) << 8 | r & 0xFF;
        }
    }
}

