/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.media.recipes;

import dan200.computercraft.shared.media.items.ItemPrintout;
import javax.annotation.Nonnull;
import net.minecraft.class_1715;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1852;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1866;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2960;

public final class PrintoutRecipe
extends class_1852 {
    private final class_1856 paper = class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8407});
    private final class_1856 leather = class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8745});
    private final class_1856 string = class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8276});
    public static final class_1866<?> SERIALIZER = new class_1866(PrintoutRecipe::new);

    private PrintoutRecipe(class_2960 id) {
        super(id);
    }

    public boolean method_8113(int x, int y) {
        return x >= 3 && y >= 3;
    }

    @Nonnull
    public class_1799 method_8110() {
        return ItemPrintout.createMultipleFromTitleAndText(null, null, null);
    }

    public boolean matches(@Nonnull class_1715 inventory, @Nonnull class_1937 world) {
        return !this.assemble(inventory).method_7960();
    }

    @Nonnull
    public class_1799 assemble(@Nonnull class_1715 inventory) {
        int numPages = 0;
        int numPrintouts = 0;
        class_1799[] printouts = null;
        boolean stringFound = false;
        boolean leatherFound = false;
        boolean printoutFound = false;
        for (int y = 0; y < inventory.method_17397(); ++y) {
            for (int x = 0; x < inventory.method_17398(); ++x) {
                ItemPrintout printout;
                class_1799 stack = inventory.method_5438(x + y * inventory.method_17398());
                if (stack.method_7960()) continue;
                class_1792 class_17922 = stack.method_7909();
                if (class_17922 instanceof ItemPrintout && (printout = (ItemPrintout)class_17922).getType() != ItemPrintout.Type.BOOK) {
                    if (printouts == null) {
                        printouts = new class_1799[9];
                    }
                    printouts[numPrintouts] = stack;
                    numPages += ItemPrintout.getPageCount(stack);
                    ++numPrintouts;
                    printoutFound = true;
                    continue;
                }
                if (this.paper.method_8093(stack)) {
                    if (printouts == null) {
                        printouts = new class_1799[9];
                    }
                    printouts[numPrintouts] = stack;
                    ++numPages;
                    ++numPrintouts;
                    continue;
                }
                if (this.string.method_8093(stack) && !stringFound) {
                    stringFound = true;
                    continue;
                }
                if (this.leather.method_8093(stack) && !leatherFound) {
                    leatherFound = true;
                    continue;
                }
                return class_1799.field_8037;
            }
        }
        if (numPages <= 16 && stringFound && printoutFound && numPrintouts >= (leatherFound ? 1 : 2)) {
            String[] text = new String[numPages * 21];
            String[] colours = new String[numPages * 21];
            int line = 0;
            for (int printout = 0; printout < numPrintouts; ++printout) {
                void stack = printouts[printout];
                if (stack.method_7909() instanceof ItemPrintout) {
                    String[] pageText = ItemPrintout.getText(printouts[printout]);
                    String[] pageColours = ItemPrintout.getColours(printouts[printout]);
                    for (int pageLine = 0; pageLine < pageText.length; ++pageLine) {
                        text[line] = pageText[pageLine];
                        colours[line] = pageColours[pageLine];
                        ++line;
                    }
                    continue;
                }
                for (int pageLine = 0; pageLine < 21; ++pageLine) {
                    text[line] = "";
                    colours[line] = "";
                    ++line;
                }
            }
            String title = null;
            if (printouts[0].method_7909() instanceof ItemPrintout) {
                title = ItemPrintout.getTitle(printouts[0]);
            }
            if (leatherFound) {
                return ItemPrintout.createBookFromTitleAndText(title, text, colours);
            }
            return ItemPrintout.createMultipleFromTitleAndText(title, text, colours);
        }
        return class_1799.field_8037;
    }

    @Nonnull
    public class_1865<?> method_8119() {
        return SERIALIZER;
    }
}

