/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.diskdrive;

import dan200.computercraft.api.filesystem.IMount;
import dan200.computercraft.api.filesystem.IWritableMount;
import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralTile;
import dan200.computercraft.shared.MediaProviders;
import dan200.computercraft.shared.common.TileGeneric;
import dan200.computercraft.shared.peripheral.diskdrive.BlockDiskDrive;
import dan200.computercraft.shared.peripheral.diskdrive.ContainerDiskDrive;
import dan200.computercraft.shared.peripheral.diskdrive.DiskDrivePeripheral;
import dan200.computercraft.shared.peripheral.diskdrive.DiskDriveState;
import dan200.computercraft.shared.util.DefaultInventory;
import dan200.computercraft.shared.util.InventoryUtil;
import dan200.computercraft.shared.util.RecordUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1273;
import net.minecraft.class_1275;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2591;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3414;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public final class TileDiskDrive
extends TileGeneric
implements IPeripheralTile,
DefaultInventory,
class_1275,
class_3908 {
    private static final String NBT_NAME = "CustomName";
    private static final String NBT_ITEM = "Item";
    class_2561 customName;
    private class_1273 lockCode = class_1273.field_5817;
    private final Map<IComputerAccess, MountInfo> computers = new HashMap<IComputerAccess, MountInfo>();
    @Nonnull
    private class_1799 diskStack = class_1799.field_8037;
    private DiskDrivePeripheral peripheral;
    private IMount diskMount = null;
    private boolean recordQueued = false;
    private boolean recordPlaying = false;
    private boolean restartRecord = false;
    private boolean ejectQueued;

    public TileDiskDrive(class_2591<TileDiskDrive> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public void destroy() {
        this.ejectContents(true);
        if (this.recordPlaying) {
            this.stopRecord();
        }
    }

    @Override
    public boolean isUsable(class_1657 player) {
        return super.isUsable(player) && class_2624.method_17487((class_1657)player, (class_1273)this.lockCode, (class_2561)this.method_5476());
    }

    @Override
    @Nonnull
    public class_1269 onActivate(class_1657 player, class_1268 hand, class_3965 hit) {
        if (player.method_18276()) {
            class_1799 disk = player.method_5998(hand);
            if (disk.method_7960()) {
                return class_1269.field_5811;
            }
            if (!this.method_10997().field_9236 && this.method_5438(0).method_7960() && MediaProviders.get(disk) != null) {
                this.setDiskStack(disk);
                player.method_6122(hand, class_1799.field_8037);
            }
            return class_1269.field_5812;
        }
        if (!this.method_10997().field_9236 && this.isUsable(player)) {
            player.method_17355((class_3908)this);
        }
        return class_1269.field_5812;
    }

    public class_2350 getDirection() {
        return (class_2350)this.method_11010().method_11654((class_2769)BlockDiskDrive.FACING);
    }

    public void method_11014(@Nonnull class_2487 nbt) {
        super.method_11014(nbt);
        class_5250 class_52502 = this.customName = nbt.method_10545(NBT_NAME) ? class_2561.class_2562.method_10877((String)nbt.method_10558(NBT_NAME)) : null;
        if (nbt.method_10545(NBT_ITEM)) {
            class_2487 item = nbt.method_10562(NBT_ITEM);
            this.diskStack = class_1799.method_7915((class_2487)item);
            this.diskMount = null;
        }
        this.lockCode = class_1273.method_5473((class_2487)nbt);
    }

    public void method_11007(@Nonnull class_2487 nbt) {
        if (this.customName != null) {
            nbt.method_10582(NBT_NAME, class_2561.class_2562.method_10867((class_2561)this.customName));
        }
        if (!this.diskStack.method_7960()) {
            class_2487 item = new class_2487();
            this.diskStack.method_7953(item);
            nbt.method_10566(NBT_ITEM, (class_2520)item);
        }
        this.lockCode.method_5474(nbt);
        super.method_11007(nbt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void serverTick() {
        if (this.ejectQueued) {
            this.ejectContents(false);
            this.ejectQueued = false;
        }
        TileDiskDrive tileDiskDrive = this;
        synchronized (tileDiskDrive) {
            if (this.recordPlaying != this.recordQueued || this.restartRecord) {
                this.restartRecord = false;
                if (this.recordQueued) {
                    class_3414 record;
                    IMedia contents = this.getDiskMedia();
                    class_3414 class_34142 = record = contents != null ? contents.getAudio(this.diskStack) : null;
                    if (record != null) {
                        this.recordPlaying = true;
                        this.playRecord();
                    } else {
                        this.recordQueued = false;
                    }
                } else {
                    this.stopRecord();
                    this.recordPlaying = false;
                }
            }
        }
    }

    public int method_5439() {
        return 1;
    }

    public boolean method_5442() {
        return this.diskStack.method_7960();
    }

    @Nonnull
    public class_1799 method_5438(int slot) {
        return this.diskStack;
    }

    @Nonnull
    public class_1799 method_5441(int slot) {
        class_1799 result = this.diskStack;
        this.diskStack = class_1799.field_8037;
        this.diskMount = null;
        return result;
    }

    @Nonnull
    public class_1799 method_5434(int slot, int count) {
        if (this.diskStack.method_7960()) {
            return class_1799.field_8037;
        }
        if (this.diskStack.method_7947() <= count) {
            class_1799 disk = this.diskStack;
            this.method_5447(slot, class_1799.field_8037);
            return disk;
        }
        class_1799 part = this.diskStack.method_7971(count);
        this.method_5447(slot, this.diskStack.method_7960() ? class_1799.field_8037 : this.diskStack);
        return part;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void method_5447(int slot, @Nonnull class_1799 stack) {
        if (this.method_10997().field_9236) {
            this.diskStack = stack;
            this.diskMount = null;
            this.method_5431();
            return;
        }
        TileDiskDrive tileDiskDrive = this;
        synchronized (tileDiskDrive) {
            Set<IComputerAccess> computers;
            if (InventoryUtil.areItemsStackable(stack, this.diskStack)) {
                this.diskStack = stack;
                return;
            }
            if (!this.diskStack.method_7960()) {
                computers = this.computers.keySet();
                for (IComputerAccess computer : computers) {
                    this.unmountDisk(computer);
                }
            }
            if (this.recordPlaying) {
                this.stopRecord();
                this.recordPlaying = false;
                this.recordQueued = false;
            }
            this.diskStack = stack;
            this.diskMount = null;
            this.method_5431();
            if (!this.diskStack.method_7960()) {
                computers = this.computers.keySet();
                for (IComputerAccess computer : computers) {
                    this.mountDisk(computer);
                }
            }
        }
    }

    public void method_5431() {
        if (!this.field_11863.field_9236) {
            this.updateBlockState();
        }
        super.method_5431();
    }

    public boolean method_5443(@Nonnull class_1657 player) {
        return this.isUsable(player);
    }

    public void method_5448() {
        this.method_5447(0, class_1799.field_8037);
    }

    @Nonnull
    class_1799 getDiskStack() {
        return this.method_5438(0);
    }

    void setDiskStack(@Nonnull class_1799 stack) {
        this.method_5447(0, stack);
    }

    private IMedia getDiskMedia() {
        return MediaProviders.get(this.getDiskStack());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getDiskMountPath(IComputerAccess computer) {
        TileDiskDrive tileDiskDrive = this;
        synchronized (tileDiskDrive) {
            MountInfo info = this.computers.get(computer);
            return info != null ? info.mountPath : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mount(IComputerAccess computer) {
        TileDiskDrive tileDiskDrive = this;
        synchronized (tileDiskDrive) {
            this.computers.put(computer, new MountInfo());
            this.mountDisk(computer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unmount(IComputerAccess computer) {
        TileDiskDrive tileDiskDrive = this;
        synchronized (tileDiskDrive) {
            this.unmountDisk(computer);
            this.computers.remove(computer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void playDiskAudio() {
        TileDiskDrive tileDiskDrive = this;
        synchronized (tileDiskDrive) {
            IMedia media = this.getDiskMedia();
            if (media != null && media.getAudioTitle(this.diskStack) != null) {
                this.recordQueued = true;
                this.restartRecord = this.recordPlaying;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopDiskAudio() {
        TileDiskDrive tileDiskDrive = this;
        synchronized (tileDiskDrive) {
            this.recordQueued = false;
            this.restartRecord = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ejectDisk() {
        TileDiskDrive tileDiskDrive = this;
        synchronized (tileDiskDrive) {
            this.ejectQueued = true;
        }
    }

    private synchronized void mountDisk(IComputerAccess computer) {
        if (!this.diskStack.method_7960()) {
            MountInfo info = this.computers.get(computer);
            IMedia contents = this.getDiskMedia();
            if (contents != null) {
                if (this.diskMount == null) {
                    this.diskMount = contents.createDataMount(this.diskStack, this.method_10997());
                }
                if (this.diskMount != null) {
                    if (this.diskMount instanceof IWritableMount) {
                        int n = 1;
                        while (info.mountPath == null) {
                            info.mountPath = computer.mountWritable((String)(n == 1 ? "disk" : "disk" + n), (IWritableMount)this.diskMount);
                            ++n;
                        }
                    } else {
                        int n = 1;
                        while (info.mountPath == null) {
                            info.mountPath = computer.mount((String)(n == 1 ? "disk" : "disk" + n), this.diskMount);
                            ++n;
                        }
                    }
                } else {
                    info.mountPath = null;
                }
            }
            computer.queueEvent("disk", computer.getAttachmentName());
        }
    }

    private synchronized void unmountDisk(IComputerAccess computer) {
        if (!this.diskStack.method_7960()) {
            MountInfo info = this.computers.get(computer);
            assert (info != null);
            if (info.mountPath != null) {
                computer.unmount(info.mountPath);
                info.mountPath = null;
            }
            computer.queueEvent("disk_eject", computer.getAttachmentName());
        }
    }

    private void updateBlockState() {
        if (this.field_11865 || this.field_11863 == null) {
            return;
        }
        if (!this.diskStack.method_7960()) {
            IMedia contents = this.getDiskMedia();
            this.updateBlockState(contents != null ? DiskDriveState.FULL : DiskDriveState.INVALID);
        } else {
            this.updateBlockState(DiskDriveState.EMPTY);
        }
    }

    private void updateBlockState(DiskDriveState state) {
        class_2680 blockState = this.method_11010();
        if (blockState.method_11654(BlockDiskDrive.STATE) == state) {
            return;
        }
        this.method_10997().method_8501(this.method_11016(), (class_2680)blockState.method_11657(BlockDiskDrive.STATE, (Comparable)((Object)state)));
    }

    private synchronized void ejectContents(boolean destroyed) {
        if (this.method_10997().field_9236 || this.diskStack.method_7960()) {
            return;
        }
        class_1799 disks = this.diskStack;
        this.setDiskStack(class_1799.field_8037);
        int xOff = 0;
        int zOff = 0;
        if (!destroyed) {
            class_2350 dir = this.getDirection();
            xOff = dir.method_10148();
            zOff = dir.method_10165();
        }
        class_2338 pos = this.method_11016();
        double x = (double)pos.method_10263() + 0.5 + (double)xOff * 0.5;
        double y = (double)pos.method_10264() + 0.75;
        double z = (double)pos.method_10260() + 0.5 + (double)zOff * 0.5;
        class_1542 entityitem = new class_1542(this.method_10997(), x, y, z, disks);
        entityitem.method_18800((double)xOff * 0.15, 0.0, (double)zOff * 0.15);
        this.method_10997().method_8649((class_1297)entityitem);
        if (!destroyed) {
            this.method_10997().method_8474(1000, this.method_11016(), 0);
        }
    }

    private void playRecord() {
        class_3414 record;
        IMedia contents = this.getDiskMedia();
        class_3414 class_34142 = record = contents != null ? contents.getAudio(this.diskStack) : null;
        if (record != null) {
            RecordUtil.playRecord(record, contents.getAudioTitle(this.diskStack), this.method_10997(), this.method_11016());
        } else {
            RecordUtil.playRecord(null, null, this.method_10997(), this.method_11016());
        }
    }

    private void stopRecord() {
        RecordUtil.playRecord(null, null, this.method_10997(), this.method_11016());
    }

    @Override
    @Nullable
    public IPeripheral getPeripheral(@NotNull class_2350 side) {
        if (this.peripheral == null) {
            this.peripheral = new DiskDrivePeripheral(this);
        }
        return this.peripheral;
    }

    public boolean method_16914() {
        return this.customName != null;
    }

    @Nullable
    public class_2561 method_5797() {
        return this.customName;
    }

    @Nonnull
    public class_2561 method_5477() {
        return this.customName != null ? this.customName : new class_2588(this.method_11010().method_26204().method_9539());
    }

    @Nonnull
    public class_2561 method_5476() {
        return super.method_5476();
    }

    @Nonnull
    public class_1703 createMenu(int id, @Nonnull class_1661 inventory, @Nonnull class_1657 player) {
        return new ContainerDiskDrive(id, inventory, this);
    }

    private static class MountInfo {
        String mountPath;

        private MountInfo() {
        }
    }
}

