/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.generic.data;

import dan200.computercraft.api.detail.BlockReference;
import dan200.computercraft.api.detail.IDetailProvider;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1799;

public final class DetailProviders {
    private static final Map<Class<?>, Collection<IDetailProvider<?>>> allProviders = new HashMap();

    public static synchronized <T> void registerProvider(Class<T> type, IDetailProvider<T> provider) {
        Objects.requireNonNull(type, "type cannot be null");
        Objects.requireNonNull(provider, "provider cannot be null");
        if (type != BlockReference.class && type != class_1799.class) {
            throw new IllegalArgumentException("type must be assignable from BlockReference or ItemStack");
        }
        allProviders.computeIfAbsent(type, k -> new LinkedHashSet()).add(provider);
    }

    public static <T> void fillData(Class<T> type, Map<? super String, Object> data, T value) {
        Collection<IDetailProvider<?>> providers = allProviders.get(type);
        if (providers == null) {
            return;
        }
        for (IDetailProvider<?> provider : providers) {
            provider.provideDetails(data, value);
        }
    }
}

