/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.modem;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.network.IPacketNetwork;
import dan200.computercraft.api.network.IPacketReceiver;
import dan200.computercraft.api.network.IPacketSender;
import dan200.computercraft.api.network.Packet;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.peripheral.modem.ModemState;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.class_1937;
import net.minecraft.class_243;

public abstract class ModemPeripheral
implements IPeripheral,
IPacketSender,
IPacketReceiver {
    private IPacketNetwork network;
    private final Set<IComputerAccess> computers = new HashSet<IComputerAccess>(1);
    private final ModemState state;

    protected ModemPeripheral(ModemState state) {
        this.state = state;
    }

    public ModemState getModemState() {
        return this.state;
    }

    private synchronized void setNetwork(IPacketNetwork network) {
        if (this.network == network) {
            return;
        }
        if (this.network != null) {
            this.network.removeReceiver(this);
        }
        this.network = network;
        if (this.network != null) {
            this.network.addReceiver(this);
        }
    }

    public void destroy() {
        this.setNetwork(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveSameDimension(@Nonnull Packet packet, double distance) {
        if (packet.sender() == this || !this.state.isOpen(packet.channel())) {
            return;
        }
        Set<IComputerAccess> set = this.computers;
        synchronized (set) {
            for (IComputerAccess computer : this.computers) {
                computer.queueEvent("modem_message", computer.getAttachmentName(), packet.channel(), packet.replyChannel(), packet.payload(), distance);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveDifferentDimension(@Nonnull Packet packet) {
        if (packet.sender() == this || !this.state.isOpen(packet.channel())) {
            return;
        }
        Set<IComputerAccess> set = this.computers;
        synchronized (set) {
            for (IComputerAccess computer : this.computers) {
                computer.queueEvent("modem_message", computer.getAttachmentName(), packet.channel(), packet.replyChannel(), packet.payload());
            }
        }
    }

    protected abstract IPacketNetwork getNetwork();

    @Override
    @Nonnull
    public String getType() {
        return "modem";
    }

    private static int parseChannel(int channel) throws LuaException {
        if (channel < 0 || channel > 65535) {
            throw new LuaException("Expected number in range 0-65535");
        }
        return channel;
    }

    @LuaFunction
    public final void open(int channel) throws LuaException {
        this.state.open(ModemPeripheral.parseChannel(channel));
    }

    @LuaFunction
    public final boolean isOpen(int channel) throws LuaException {
        return this.state.isOpen(ModemPeripheral.parseChannel(channel));
    }

    @LuaFunction
    public final void close(int channel) throws LuaException {
        this.state.close(ModemPeripheral.parseChannel(channel));
    }

    @LuaFunction
    public final void closeAll() {
        this.state.closeAll();
    }

    @LuaFunction
    public final void transmit(int channel, int replyChannel, Object payload) throws LuaException {
        ModemPeripheral.parseChannel(channel);
        ModemPeripheral.parseChannel(replyChannel);
        class_1937 world = this.getLevel();
        class_243 position = this.getPosition();
        IPacketNetwork network = this.network;
        if (world == null || position == null || network == null) {
            return;
        }
        Packet packet = new Packet(channel, replyChannel, payload, this);
        if (this.isInterdimensional()) {
            network.transmitInterdimensional(packet);
        } else {
            network.transmitSameDimension(packet, this.getRange());
        }
    }

    @LuaFunction
    public final boolean isWireless() {
        IPacketNetwork network = this.network;
        return network != null && network.isWireless();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void attach(@Nonnull IComputerAccess computer) {
        Set<IComputerAccess> set = this.computers;
        synchronized (set) {
            this.computers.add(computer);
        }
        this.setNetwork(this.getNetwork());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void detach(@Nonnull IComputerAccess computer) {
        boolean empty;
        Set<IComputerAccess> set = this.computers;
        synchronized (set) {
            this.computers.remove(computer);
            empty = this.computers.isEmpty();
        }
        if (empty) {
            this.setNetwork(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public String getSenderID() {
        Set<IComputerAccess> set = this.computers;
        synchronized (set) {
            if (this.computers.size() != 1) {
                return "unknown";
            }
            IComputerAccess computer = this.computers.iterator().next();
            return computer.getID() + "_" + computer.getAttachmentName();
        }
    }
}

