/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.modem.wireless;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralTile;
import dan200.computercraft.shared.common.TileGeneric;
import dan200.computercraft.shared.peripheral.modem.ModemPeripheral;
import dan200.computercraft.shared.peripheral.modem.ModemState;
import dan200.computercraft.shared.peripheral.modem.wireless.BlockWirelessModem;
import dan200.computercraft.shared.peripheral.modem.wireless.WirelessModemPeripheral;
import dan200.computercraft.shared.util.TickScheduler;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public class TileWirelessModem
extends TileGeneric
implements IPeripheralTile {
    private final boolean advanced;
    private final ModemPeripheral modem;
    private boolean destroyed = false;

    public TileWirelessModem(class_2591<? extends TileWirelessModem> type, class_2338 pos, class_2680 state, boolean advanced) {
        super(type, pos, state);
        this.advanced = advanced;
        this.modem = new Peripheral(this);
    }

    public void method_10996() {
        super.method_10996();
        TickScheduler.schedule(this);
    }

    @Override
    public void destroy() {
        if (!this.destroyed) {
            this.modem.destroy();
            this.destroyed = true;
        }
    }

    @Override
    public void blockTick() {
        if (this.modem.getModemState().pollChanged()) {
            this.updateBlockState();
        }
    }

    @Nonnull
    private class_2350 getDirection() {
        return (class_2350)this.method_11010().method_11654((class_2769)BlockWirelessModem.FACING);
    }

    private void updateBlockState() {
        boolean on = this.modem.getModemState().isOpen();
        class_2680 state = this.method_11010();
        if ((Boolean)state.method_11654((class_2769)BlockWirelessModem.ON) != on) {
            this.method_10997().method_8501(this.method_11016(), (class_2680)state.method_11657((class_2769)BlockWirelessModem.ON, (Comparable)Boolean.valueOf(on)));
        }
    }

    @Override
    @Nullable
    public IPeripheral getPeripheral(class_2350 side) {
        if (side != null && this.getDirection() != side) {
            return null;
        }
        return this.modem;
    }

    private static class Peripheral
    extends WirelessModemPeripheral {
        private final TileWirelessModem entity;

        Peripheral(TileWirelessModem entity) {
            super(new ModemState(() -> TickScheduler.schedule(entity)), entity.advanced);
            this.entity = entity;
        }

        @Override
        @Nonnull
        public class_1937 getLevel() {
            return this.entity.method_10997();
        }

        @Override
        @Nonnull
        public class_243 getPosition() {
            return class_243.method_24954((class_2382)this.entity.method_11016().method_10093(this.entity.getDirection()));
        }

        @Override
        public boolean equals(IPeripheral other) {
            return this == other || other instanceof Peripheral && this.entity == ((Peripheral)other).entity;
        }

        @Override
        @Nonnull
        public Object getTarget() {
            return this.entity;
        }
    }
}

