/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.speaker;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.LuaTable;
import dan200.computercraft.api.lua.LuaValues;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.network.NetworkHandler;
import dan200.computercraft.shared.network.client.SpeakerAudioClientMessage;
import dan200.computercraft.shared.network.client.SpeakerMoveClientMessage;
import dan200.computercraft.shared.network.client.SpeakerPlayClientMessage;
import dan200.computercraft.shared.network.client.SpeakerStopClientMessage;
import dan200.computercraft.shared.peripheral.speaker.DfpwmState;
import dan200.computercraft.shared.peripheral.speaker.SpeakerPosition;
import dan200.computercraft.shared.util.PauseAwareTimer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.class_151;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2660;
import net.minecraft.class_2766;
import net.minecraft.class_2960;
import net.minecraft.class_3419;
import net.minecraft.server.MinecraftServer;

public abstract class SpeakerPeripheral
implements IPeripheral {
    public static final int SAMPLE_RATE = 48000;
    private final UUID source = UUID.randomUUID();
    private final Set<IComputerAccess> computers = new HashSet<IComputerAccess>();
    private long clock = 0L;
    private long lastPositionTime;
    private SpeakerPosition lastPosition;
    private long lastPlayTime;
    private final List<PendingSound> pendingNotes = new ArrayList<PendingSound>();
    private final Object lock = new Object();
    private boolean shouldStop;
    private PendingSound pendingSound = null;
    private DfpwmState dfpwmState;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        boolean shouldStop;
        DfpwmState dfpwmState;
        PendingSound sound;
        ++this.clock;
        SpeakerPosition position = this.getPosition();
        class_1937 level = position.level();
        class_243 pos = position.position();
        if (level == null) {
            return;
        }
        MinecraftServer server = level.method_8503();
        List<PendingSound> list = this.pendingNotes;
        synchronized (list) {
            for (PendingSound sound2 : this.pendingNotes) {
                this.lastPlayTime = this.clock;
                server.method_3760().method_14605(null, pos.field_1352, pos.field_1351, pos.field_1350, (double)(sound2.volume * 16.0f), level.method_27983(), (class_2596)new class_2660(sound2.location, class_3419.field_15247, pos, sound2.volume, sound2.pitch));
            }
            this.pendingNotes.clear();
        }
        Object object = this.lock;
        synchronized (object) {
            sound = this.pendingSound;
            dfpwmState = this.dfpwmState;
            this.pendingSound = null;
            shouldStop = this.shouldStop;
            if (shouldStop) {
                this.dfpwmState = null;
                dfpwmState = null;
                sound = null;
                this.shouldStop = false;
            }
        }
        if (shouldStop && this.lastPosition != null) {
            this.lastPosition = null;
            NetworkHandler.sendToAllPlayers(new SpeakerStopClientMessage(this.getSource()));
            return;
        }
        long now = PauseAwareTimer.getTime();
        if (sound != null) {
            this.lastPlayTime = this.clock;
            NetworkHandler.sendToAllAround(new SpeakerPlayClientMessage(this.getSource(), position, sound.location, sound.volume, sound.pitch), level, pos, sound.volume * 16.0f);
            this.syncedPosition(position);
        } else if (dfpwmState != null && dfpwmState.shouldSendPending(now)) {
            NetworkHandler.sendToAllTracking(new SpeakerAudioClientMessage(this.getSource(), position, dfpwmState.getVolume(), dfpwmState.pullPending(now)), level.method_8500(new class_2338(pos)));
            this.syncedPosition(position);
            Set<IComputerAccess> set = this.computers;
            synchronized (set) {
                for (IComputerAccess computer : this.computers) {
                    computer.queueEvent("speaker_audio_empty", computer.getAttachmentName());
                }
            }
        }
        if (this.lastPosition != null && this.clock - this.lastPositionTime >= 20L && !this.lastPosition.withinDistance(position, 0.1)) {
            NetworkHandler.sendToAllTracking(new SpeakerMoveClientMessage(this.getSource(), position), level.method_8500(new class_2338(pos)));
            this.syncedPosition(position);
        }
    }

    @Nonnull
    public abstract SpeakerPosition getPosition();

    @Nonnull
    public UUID getSource() {
        return this.source;
    }

    public boolean madeSound() {
        DfpwmState state = this.dfpwmState;
        return this.clock - this.lastPlayTime <= 20L || state != null && state.isPlaying();
    }

    @Override
    @Nonnull
    public String getType() {
        return "speaker";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LuaFunction
    public final boolean playNote(ILuaContext context, String instrumentA, Optional<Double> volumeA, Optional<Double> pitchA) throws LuaException {
        float volume = (float)LuaValues.checkFinite(1, volumeA.orElse(1.0));
        float pitch = (float)LuaValues.checkFinite(2, pitchA.orElse(1.0));
        class_2766 instrument = null;
        for (class_2766 testInstrument : class_2766.values()) {
            if (!testInstrument.method_15434().equalsIgnoreCase(instrumentA)) continue;
            instrument = testInstrument;
            break;
        }
        if (instrument == null) {
            throw new LuaException("Invalid instrument, \"" + instrument + "\"!");
        }
        List<PendingSound> list = this.pendingNotes;
        synchronized (list) {
            if (this.pendingNotes.size() >= ComputerCraft.maxNotesPerTick) {
                return false;
            }
            this.pendingNotes.add(new PendingSound(instrument.method_11886().method_14833(), volume, (float)Math.pow(2.0, ((double)pitch - 12.0) / 12.0)));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LuaFunction
    public final boolean playSound(ILuaContext context, String name, Optional<Double> volumeA, Optional<Double> pitchA) throws LuaException {
        class_2960 identifier;
        float volume = (float)LuaValues.checkFinite(1, volumeA.orElse(1.0));
        float pitch = (float)LuaValues.checkFinite(2, pitchA.orElse(1.0));
        try {
            identifier = new class_2960(name);
        }
        catch (class_151 e) {
            throw new LuaException("Malformed sound name '" + name + "' ");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.dfpwmState != null && this.dfpwmState.isPlaying()) {
                return false;
            }
            this.dfpwmState = null;
            this.pendingSound = new PendingSound(identifier, volume, pitch);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LuaFunction(unsafe=true)
    public final boolean playAudio(ILuaContext context, LuaTable<?, ?> audio, Optional<Double> volume) throws LuaException {
        DfpwmState state;
        LuaValues.checkFinite(1, volume.orElse(0.0));
        int length = audio.length();
        if (length <= 0) {
            throw new LuaException("Cannot play empty audio");
        }
        if (length > 131072) {
            throw new LuaException("Audio data is too large");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.dfpwmState == null || !this.dfpwmState.isPlaying()) {
                this.dfpwmState = new DfpwmState();
            }
            state = this.dfpwmState;
            this.pendingSound = null;
        }
        return state.pushBuffer(audio, length, volume);
    }

    @LuaFunction
    public final void stop() {
        this.shouldStop = true;
    }

    private void syncedPosition(SpeakerPosition position) {
        this.lastPosition = position;
        this.lastPositionTime = this.clock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void attach(@Nonnull IComputerAccess computer) {
        Set<IComputerAccess> set = this.computers;
        synchronized (set) {
            this.computers.add(computer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detach(@Nonnull IComputerAccess computer) {
        Set<IComputerAccess> set = this.computers;
        synchronized (set) {
            this.computers.remove(computer);
        }
    }

    private record PendingSound(class_2960 location, float volume, float pitch) {
    }
}

