/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.pocket.apis;

import dan200.computercraft.api.lua.ILuaAPI;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.shared.PocketUpgrades;
import dan200.computercraft.shared.pocket.core.PocketServerComputer;
import dan200.computercraft.shared.util.InventoryUtil;
import dan200.computercraft.shared.util.ItemStorage;
import dan200.computercraft.shared.util.WorldUtil;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2371;

public class PocketAPI
implements ILuaAPI {
    private final PocketServerComputer computer;

    public PocketAPI(PocketServerComputer computer) {
        this.computer = computer;
    }

    @Override
    public String[] getNames() {
        return new String[]{"pocket"};
    }

    @LuaFunction(mainThread=true)
    public final Object[] equipBack() {
        class_1799 stack;
        class_1297 entity = this.computer.getEntity();
        if (!(entity instanceof class_1657)) {
            return new Object[]{false, "Cannot find player"};
        }
        class_1657 player = (class_1657)entity;
        class_1661 inventory = player.method_31548();
        IPocketUpgrade previousUpgrade = this.computer.getUpgrade();
        IPocketUpgrade newUpgrade = PocketAPI.findUpgrade((class_2371<class_1799>)inventory.field_7547, inventory.field_7545, previousUpgrade);
        if (newUpgrade == null) {
            newUpgrade = PocketAPI.findUpgrade((class_2371<class_1799>)inventory.field_7544, 0, previousUpgrade);
        }
        if (newUpgrade == null) {
            return new Object[]{false, "Cannot find a valid upgrade"};
        }
        if (previousUpgrade != null && !(stack = previousUpgrade.getCraftingItem()).method_7960() && !(stack = InventoryUtil.storeItems(stack, ItemStorage.wrap((class_1263)inventory), inventory.field_7545)).method_7960()) {
            WorldUtil.dropItemStack(stack, player.method_5770(), player.method_19538());
        }
        this.computer.setUpgrade(newUpgrade);
        return new Object[]{true};
    }

    @LuaFunction(mainThread=true)
    public final Object[] unequipBack() {
        class_1297 entity = this.computer.getEntity();
        if (!(entity instanceof class_1657)) {
            return new Object[]{false, "Cannot find player"};
        }
        class_1657 player = (class_1657)entity;
        class_1661 inventory = player.method_31548();
        IPocketUpgrade previousUpgrade = this.computer.getUpgrade();
        if (previousUpgrade == null) {
            return new Object[]{false, "Nothing to unequip"};
        }
        this.computer.setUpgrade(null);
        class_1799 stack = previousUpgrade.getCraftingItem();
        if (!stack.method_7960() && (stack = InventoryUtil.storeItems(stack, ItemStorage.wrap((class_1263)inventory), inventory.field_7545)).method_7960()) {
            WorldUtil.dropItemStack(stack, player.method_5770(), player.method_19538());
        }
        return new Object[]{true};
    }

    private static IPocketUpgrade findUpgrade(class_2371<class_1799> inv, int start, IPocketUpgrade previous) {
        for (int i = 0; i < inv.size(); ++i) {
            IPocketUpgrade newUpgrade;
            class_1799 invStack = (class_1799)inv.get((i + start) % inv.size());
            if (invStack.method_7960() || (newUpgrade = PocketUpgrades.get(invStack)) == null || newUpgrade == previous) continue;
            invStack = invStack.method_7972();
            invStack.method_7934(1);
            inv.set((i + start) % inv.size(), (Object)(invStack.method_7960() ? class_1799.field_8037 : invStack));
            return newUpgrade;
        }
        return null;
    }
}

