/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.pocket.core;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.pocket.IPocketAccess;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.shared.common.IColouredItem;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.network.NetworkHandler;
import dan200.computercraft.shared.pocket.items.ItemPocketComputer;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class PocketServerComputer
extends ServerComputer
implements IPocketAccess {
    private IPocketUpgrade upgrade;
    private class_1297 entity;
    private class_1799 stack;

    public PocketServerComputer(class_1937 world, int computerID, String label, int instanceID, ComputerFamily family) {
        super(world, computerID, label, instanceID, family, ComputerCraft.pocketTermWidth, ComputerCraft.pocketTermHeight);
    }

    @Override
    @Nullable
    public class_1297 getEntity() {
        class_1297 entity = this.entity;
        if (entity == null || this.stack == null || !entity.method_5805()) {
            return null;
        }
        if (entity instanceof class_1657) {
            class_1661 inventory = ((class_1657)entity).method_31548();
            return inventory.field_7547.contains((Object)this.stack) || inventory.field_7544.contains((Object)this.stack) ? entity : null;
        }
        if (entity instanceof class_1309) {
            class_1309 living = (class_1309)entity;
            return living.method_6047() == this.stack || living.method_6079() == this.stack ? entity : null;
        }
        if (entity instanceof class_1542) {
            class_1542 itemEntity = (class_1542)entity;
            return itemEntity.method_6983() == this.stack ? entity : null;
        }
        return null;
    }

    @Override
    public int getColour() {
        return IColouredItem.getColourBasic(this.stack);
    }

    @Override
    public void setColour(int colour) {
        IColouredItem.setColourBasic(this.stack, colour);
        this.updateUpgradeNBTData();
    }

    @Override
    public int getLight() {
        class_2487 tag = this.getUserData();
        return tag.method_10573("Light", 99) ? tag.method_10550("Light") : -1;
    }

    @Override
    public void setLight(int colour) {
        class_2487 tag = this.getUserData();
        if (colour >= 0 && colour <= 0xFFFFFF) {
            if (!tag.method_10573("Light", 99) || tag.method_10550("Light") != colour) {
                tag.method_10569("Light", colour);
                this.updateUserData();
            }
        } else if (tag.method_10573("Light", 99)) {
            tag.method_10551("Light");
            this.updateUserData();
        }
    }

    @Override
    @Nonnull
    public class_2487 getUpgradeNBTData() {
        return ItemPocketComputer.getUpgradeInfo(this.stack);
    }

    @Override
    public void updateUpgradeNBTData() {
        class_1297 class_12972 = this.entity;
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            player.method_31548().method_5431();
        }
    }

    @Override
    public void invalidatePeripheral() {
        IPeripheral peripheral = this.upgrade == null ? null : this.upgrade.createPeripheral(this);
        this.setPeripheral(ComputerSide.BACK, peripheral);
    }

    @Override
    @Nonnull
    public Map<class_2960, IPeripheral> getUpgrades() {
        return this.upgrade == null ? Collections.emptyMap() : Collections.singletonMap(this.upgrade.getUpgradeID(), this.getPeripheral(ComputerSide.BACK));
    }

    public IPocketUpgrade getUpgrade() {
        return this.upgrade;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUpgrade(IPocketUpgrade upgrade) {
        if (this.upgrade == upgrade) {
            return;
        }
        PocketServerComputer pocketServerComputer = this;
        synchronized (pocketServerComputer) {
            ItemPocketComputer.setUpgrade(this.stack, upgrade);
            this.updateUpgradeNBTData();
            this.upgrade = upgrade;
            this.invalidatePeripheral();
        }
    }

    public synchronized void updateValues(class_1297 entity, @Nonnull class_1799 stack, IPocketUpgrade upgrade) {
        if (entity != null) {
            this.setLevel(entity.method_5770());
            this.setPosition(entity.method_24515());
        }
        if (entity != this.entity && entity instanceof class_3222) {
            this.markTerminalChanged();
        }
        this.entity = entity;
        this.stack = stack;
        if (this.upgrade != upgrade) {
            this.upgrade = upgrade;
            this.invalidatePeripheral();
        }
    }

    @Override
    public void broadcastState(boolean force) {
        class_1297 class_12972;
        super.broadcastState(force);
        if ((this.hasTerminalChanged() || force) && (class_12972 = this.entity) instanceof class_3222) {
            class_3222 player = (class_3222)class_12972;
            if (player.field_13987 != null && !this.isInteracting((class_1657)player)) {
                NetworkHandler.sendToPlayer((class_1657)player, this.createTerminalPacket());
            }
        }
    }
}

