/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle;

import com.google.common.eventbus.Subscribe;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.event.TurtleRefuelEvent;
import dan200.computercraft.shared.util.InventoryUtil;
import dan200.computercraft.shared.util.WorldUtil;
import javax.annotation.Nonnull;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_3866;

public final class FurnaceRefuelHandler
implements TurtleRefuelEvent.Handler {
    public static final FurnaceRefuelHandler INSTANCE = new FurnaceRefuelHandler();

    private FurnaceRefuelHandler() {
    }

    @Override
    public int refuel(@Nonnull ITurtleAccess turtle, @Nonnull class_1799 currentStack, int slot, int limit) {
        class_1799 remainder;
        int fuelPerItem;
        int fuelSpaceLeft = turtle.getFuelLimit() - turtle.getFuelLevel();
        int fuelItemLimit = (int)Math.ceil((double)fuelSpaceLeft / (double)(fuelPerItem = FurnaceRefuelHandler.getFuelPerItem(turtle.getItemHandler().getStack(slot))));
        if (limit > fuelItemLimit) {
            limit = fuelItemLimit;
        }
        class_1799 stack = turtle.getItemHandler().take(slot, limit, class_1799.field_8037, false);
        int fuelToGive = fuelPerItem * stack.method_7947();
        class_1792 replacementStack = stack.method_7909().method_7858();
        if (replacementStack != null && !(remainder = InventoryUtil.storeItems(new class_1799((class_1935)replacementStack), turtle.getItemHandler(), turtle.getSelectedSlot())).method_7960()) {
            WorldUtil.dropItemStack(remainder, turtle.getLevel(), turtle.getPosition(), turtle.getDirection().method_10153());
        }
        return fuelToGive;
    }

    private static int getFuelPerItem(@Nonnull class_1799 stack) {
        int burnTime = class_3866.method_11196().getOrDefault(stack.method_7909(), 0);
        return burnTime * 5 / 100;
    }

    @Subscribe
    public static void onTurtleRefuel(TurtleRefuelEvent event) {
        if (event.getHandler() == null && FurnaceRefuelHandler.getFuelPerItem(event.getStack()) > 0) {
            event.setHandler(INSTANCE);
        }
    }
}

