/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleCommand;
import dan200.computercraft.api.turtle.TurtleAnimation;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.shared.turtle.core.InteractDirection;
import dan200.computercraft.shared.util.InventoryUtil;
import dan200.computercraft.shared.util.ItemStorage;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.class_1263;
import net.minecraft.class_1301;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;

public class TurtleSuckCommand
implements ITurtleCommand {
    private final InteractDirection direction;
    private final int quantity;

    public TurtleSuckCommand(InteractDirection direction, int quantity) {
        this.direction = direction;
        this.quantity = quantity;
    }

    @Override
    @Nonnull
    public TurtleCommandResult execute(@Nonnull ITurtleAccess turtle) {
        class_2350 side;
        class_2338 turtlePosition;
        class_2338 blockPosition;
        if (this.quantity == 0) {
            turtle.playAnimation(TurtleAnimation.WAIT);
            return TurtleCommandResult.success();
        }
        class_2350 direction = this.direction.toWorldDir(turtle);
        class_1937 world = turtle.getLevel();
        class_1263 inventoryContainer = InventoryUtil.getInventory(world, blockPosition = (turtlePosition = turtle.getPosition()).method_10093(direction), side = direction.method_10153());
        if (inventoryContainer != null) {
            ItemStorage inventory = ItemStorage.wrap(inventoryContainer);
            class_1799 stack = InventoryUtil.takeItems(this.quantity, inventory);
            if (stack.method_7960()) {
                return TurtleCommandResult.failure("No items to take");
            }
            class_1799 remainder = InventoryUtil.storeItems(stack, turtle.getItemHandler(), turtle.getSelectedSlot());
            if (!remainder.method_7960()) {
                InventoryUtil.storeItems(remainder, inventory);
            }
            if (remainder != stack) {
                turtle.playAnimation(TurtleAnimation.WAIT);
                return TurtleCommandResult.success();
            }
            return TurtleCommandResult.failure("No space for items");
        }
        class_238 aabb = new class_238((double)blockPosition.method_10263(), (double)blockPosition.method_10264(), (double)blockPosition.method_10260(), (double)blockPosition.method_10263() + 1.0, (double)blockPosition.method_10264() + 1.0, (double)blockPosition.method_10260() + 1.0);
        List list = world.method_8390(class_1542.class, aabb, class_1301.field_6154);
        if (list.isEmpty()) {
            return TurtleCommandResult.failure("No items to take");
        }
        for (class_1542 entity : list) {
            class_1799 remainder;
            class_1799 leaveStack;
            class_1799 storeStack;
            class_1799 stack = entity.method_6983().method_7972();
            if (stack.method_7947() > this.quantity) {
                storeStack = stack.method_7971(this.quantity);
                leaveStack = stack;
            } else {
                storeStack = stack;
                leaveStack = class_1799.field_8037;
            }
            if ((remainder = InventoryUtil.storeItems(storeStack, turtle.getItemHandler(), turtle.getSelectedSlot())) == storeStack) continue;
            if (remainder.method_7960() && leaveStack.method_7960()) {
                entity.method_31472();
            } else if (remainder.method_7960()) {
                entity.method_6979(leaveStack);
            } else if (leaveStack.method_7960()) {
                entity.method_6979(remainder);
            } else {
                leaveStack.method_7933(remainder.method_7947());
                entity.method_6979(leaveStack);
            }
            world.method_8474(1000, turtlePosition, 0);
            turtle.playAnimation(TurtleAnimation.WAIT);
            return TurtleCommandResult.success();
        }
        return TurtleCommandResult.failure("No space for items");
    }
}

