/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.upgrades;

import dan200.computercraft.api.client.TransformedModel;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.AbstractTurtleUpgrade;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.turtle.TurtleUpgradeType;
import dan200.computercraft.api.turtle.TurtleVerb;
import dan200.computercraft.shared.peripheral.modem.ModemState;
import dan200.computercraft.shared.peripheral.modem.wireless.WirelessModemPeripheral;
import javax.annotation.Nonnull;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1091;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2960;

public class TurtleModem
extends AbstractTurtleUpgrade {
    private final boolean advanced;
    @Environment(value=EnvType.CLIENT)
    private Models models;

    public TurtleModem(class_2960 id, class_1799 stack, boolean advanced) {
        super(id, TurtleUpgradeType.PERIPHERAL, advanced ? "upgrade.computercraft.wireless_modem_advanced.adjective" : "upgrade.computercraft.wireless_modem_normal.adjective", stack);
        this.advanced = advanced;
    }

    @Override
    public IPeripheral createPeripheral(@Nonnull ITurtleAccess turtle, @Nonnull TurtleSide side) {
        return new Peripheral(turtle, this.advanced);
    }

    @Override
    @Nonnull
    public TurtleCommandResult useTool(@Nonnull ITurtleAccess turtle, @Nonnull TurtleSide side, @Nonnull TurtleVerb verb, @Nonnull class_2350 dir) {
        return TurtleCommandResult.failure();
    }

    @Override
    @Nonnull
    @Environment(value=EnvType.CLIENT)
    public TransformedModel getModel(ITurtleAccess turtle, @Nonnull TurtleSide side) {
        if (this.models == null) {
            this.models = new Models();
        }
        boolean active = false;
        if (turtle != null) {
            class_2487 turtleNBT = turtle.getUpgradeNBTData(side);
            boolean bl = active = turtleNBT.method_10545("active") && turtleNBT.method_10577("active");
        }
        return side == TurtleSide.LEFT ? TransformedModel.of(active ? this.models.leftOnModel : this.models.leftOffModel) : TransformedModel.of(active ? this.models.rightOnModel : this.models.rightOffModel);
    }

    @Override
    public void update(@Nonnull ITurtleAccess turtle, @Nonnull TurtleSide side) {
        Peripheral modem;
        ModemState state;
        IPeripheral peripheral;
        if (!turtle.getLevel().field_9236 && (peripheral = turtle.getPeripheral(side)) instanceof Peripheral && (state = (modem = (Peripheral)peripheral).getModemState()).pollChanged()) {
            turtle.getUpgradeNBTData(side).method_10556("active", state.isOpen());
            turtle.updateUpgradeNBTData(side);
        }
    }

    private static class Peripheral
    extends WirelessModemPeripheral {
        private final ITurtleAccess turtle;

        Peripheral(ITurtleAccess turtle, boolean advanced) {
            super(new ModemState(), advanced);
            this.turtle = turtle;
        }

        @Override
        @Nonnull
        public class_1937 getLevel() {
            return this.turtle.getLevel();
        }

        @Override
        @Nonnull
        public class_243 getPosition() {
            class_2338 turtlePos = this.turtle.getPosition();
            return new class_243((double)turtlePos.method_10263(), (double)turtlePos.method_10264(), (double)turtlePos.method_10260());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(IPeripheral other) {
            if (this == other) return true;
            if (!(other instanceof Peripheral)) return false;
            Peripheral modem = (Peripheral)other;
            if (modem.turtle != this.turtle) return false;
            return true;
        }
    }

    @Environment(value=EnvType.CLIENT)
    private class Models {
        private final class_1091 leftOffModel;
        private final class_1091 rightOffModel;
        private final class_1091 leftOnModel;
        private final class_1091 rightOnModel;

        private Models() {
            this.leftOffModel = TurtleModem.this.advanced ? new class_1091("computercraft:turtle_modem_advanced_off_left", "inventory") : new class_1091("computercraft:turtle_modem_normal_off_left", "inventory");
            this.rightOffModel = TurtleModem.this.advanced ? new class_1091("computercraft:turtle_modem_advanced_off_right", "inventory") : new class_1091("computercraft:turtle_modem_normal_off_right", "inventory");
            this.leftOnModel = TurtleModem.this.advanced ? new class_1091("computercraft:turtle_modem_advanced_on_left", "inventory") : new class_1091("computercraft:turtle_modem_normal_on_left", "inventory");
            this.rightOnModel = TurtleModem.this.advanced ? new class_1091("computercraft:turtle_modem_advanced_on_right", "inventory") : new class_1091("computercraft:turtle_modem_normal_on_right", "inventory");
        }
    }
}

