/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt.lib;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.squiddev.cobalt.Buffer;
import org.squiddev.cobalt.Constants;
import org.squiddev.cobalt.ErrorFactory;
import org.squiddev.cobalt.LuaError;
import org.squiddev.cobalt.LuaInteger;
import org.squiddev.cobalt.LuaState;
import org.squiddev.cobalt.LuaString;
import org.squiddev.cobalt.LuaTable;
import org.squiddev.cobalt.LuaValue;
import org.squiddev.cobalt.NonResumableException;
import org.squiddev.cobalt.OperationHelper;
import org.squiddev.cobalt.UnwindThrowable;
import org.squiddev.cobalt.ValueFactory;
import org.squiddev.cobalt.Varargs;
import org.squiddev.cobalt.compiler.DumpState;
import org.squiddev.cobalt.debug.DebugFrame;
import org.squiddev.cobalt.function.LibFunction;
import org.squiddev.cobalt.function.LuaClosure;
import org.squiddev.cobalt.function.LuaFunction;
import org.squiddev.cobalt.function.OneArgFunction;
import org.squiddev.cobalt.function.ResumableVarArgFunction;
import org.squiddev.cobalt.function.VarArgFunction;
import org.squiddev.cobalt.lib.LuaLibrary;
import org.squiddev.cobalt.lib.StringFormat;
import org.squiddev.cobalt.lib.StringMatch;
import org.squiddev.cobalt.lib.StringPacker;

public class StringLib
implements LuaLibrary {
    static final int L_ESC = 37;

    @Override
    public LuaValue add(LuaState state, LuaTable env) {
        LuaTable t = new LuaTable();
        LibFunction.bind(t, StringLib1::new, new String[]{"len", "lower", "reverse", "upper", "packsize"});
        LibFunction.bind(t, StringLibV::new, new String[]{"dump", "byte", "char", "find", "gmatch", "match", "rep", "sub", "pack", "unpack"});
        LibFunction.bind(t, StringLibR::new, new String[]{"gsub", "format"});
        t.rawset("gfind", t.rawget("gmatch"));
        env.rawset("string", (LuaValue)t);
        state.stringMetatable = ValueFactory.tableOf(Constants.INDEX, t);
        state.loadedPackages.rawset("string", (LuaValue)t);
        return t;
    }

    static Varargs byte_(Varargs args) throws LuaError {
        LuaString s = args.arg(1).checkLuaString();
        int l = s.length;
        int posi = StringLib.posRelative(args.arg(2).optInteger(1), l);
        int pose = StringLib.posRelative(args.arg(3).optInteger(posi), l);
        if (posi <= 0) {
            posi = 1;
        }
        if (pose > l) {
            pose = l;
        }
        if (posi > pose) {
            return Constants.NONE;
        }
        int n = pose - posi + 1;
        if (posi + n <= pose) {
            throw new LuaError("string slice too long");
        }
        LuaValue[] v = new LuaValue[n];
        for (int i = 0; i < n; ++i) {
            v[i] = ValueFactory.valueOf(s.luaByte(posi + i - 1));
        }
        return ValueFactory.varargsOf(v);
    }

    public static Varargs char_(Varargs args) throws LuaError {
        int n = args.count();
        byte[] bytes = new byte[n];
        int i = 0;
        int a = 1;
        while (i < n) {
            int c = args.arg(a).checkInteger();
            if (c < 0 || c >= 256) {
                throw ErrorFactory.argError(a, "invalid value");
            }
            bytes[i] = (byte)c;
            ++i;
            ++a;
        }
        return LuaString.valueOf(bytes);
    }

    static LuaValue dump(LuaFunction f, boolean strip) throws LuaError {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            if (f instanceof LuaClosure) {
                DumpState.dump(((LuaClosure)f).getPrototype(), baos, strip);
                return LuaString.valueOf(baos.toByteArray());
            }
            throw new LuaError("Unable to dump given function");
        }
        catch (IOException e) {
            throw new LuaError(e.getMessage());
        }
    }

    static Varargs rep(Varargs args) throws LuaError {
        LuaString s = args.arg(1).checkLuaString();
        int n = args.arg(2).checkInteger();
        int len = s.length();
        if (n <= 0 || len == 0) {
            return Constants.EMPTYSTRING;
        }
        if (n == 1) {
            return s;
        }
        byte[] bytes = new byte[len * n];
        for (int offset = 0; offset < bytes.length; offset += len) {
            s.copyTo(0, bytes, offset, len);
        }
        return LuaString.valueOf(bytes);
    }

    static Varargs sub(Varargs args) throws LuaError {
        LuaString s = args.arg(1).checkLuaString();
        int l = s.length();
        int start = StringLib.posRelative(args.arg(2).checkInteger(), l);
        int defval = -1;
        int end = StringLib.posRelative(args.arg(3).optInteger(defval), l);
        if (start < 1) {
            start = 1;
        }
        if (end > l) {
            end = l;
        }
        if (start <= end) {
            return s.substring(start - 1, end);
        }
        return Constants.EMPTYSTRING;
    }

    static int posRelative(int pos, int len) {
        if (pos >= 0) {
            return pos;
        }
        if (-pos > len) {
            return 0;
        }
        return len + pos + 1;
    }

    public static boolean isWhitespace(byte b) {
        return StringMatch.isWhitespace(b);
    }

    static final class StringLibR
    extends ResumableVarArgFunction<Object> {
        StringLibR() {
        }

        @Override
        public Varargs invoke(LuaState state, DebugFrame di, Varargs args) throws LuaError, UnwindThrowable {
            switch (this.opcode) {
                case 0: {
                    LuaString src = args.arg(1).checkLuaString();
                    LuaString p = args.arg(2).checkLuaString();
                    LuaValue replace = args.arg(3);
                    int maxS = args.arg(4).optInteger(src.length() + 1);
                    StringMatch.GSubState gsub = new StringMatch.GSubState(state, src, p, replace, maxS);
                    di.state = gsub;
                    return StringMatch.gsubRun(state, gsub, null);
                }
                case 1: {
                    LuaString src = args.arg(1).checkLuaString();
                    StringFormat.FormatState format = new StringFormat.FormatState(src, new Buffer(src.length), args);
                    di.state = format;
                    return StringFormat.format(state, format);
                }
            }
            return Constants.NONE;
        }

        @Override
        public Varargs resumeThis(LuaState state, Object object, Varargs value) throws LuaError, UnwindThrowable {
            switch (this.opcode) {
                case 0: {
                    return StringMatch.gsubRun(state, (StringMatch.GSubState)object, value.first());
                }
                case 1: {
                    StringFormat.FormatState format = (StringFormat.FormatState)object;
                    StringFormat.addString(format.buffer, format.current, OperationHelper.checkToString(value.first()));
                    return StringFormat.format(state, format);
                }
            }
            throw new NonResumableException("Cannot resume " + this.debugName());
        }
    }

    static final class StringLibV
    extends VarArgFunction {
        StringLibV() {
        }

        @Override
        public Varargs invoke(LuaState state, Varargs args) throws LuaError {
            switch (this.opcode) {
                case 0: {
                    return StringLib.dump(args.arg(1).checkFunction(), args.arg(2).optBoolean(false));
                }
                case 1: {
                    return StringLib.byte_(args);
                }
                case 2: {
                    return StringLib.char_(args);
                }
                case 3: {
                    return StringMatch.find(state, args);
                }
                case 4: {
                    return StringMatch.gmatch(state, args);
                }
                case 5: {
                    return StringMatch.match(state, args);
                }
                case 6: {
                    return StringLib.rep(args);
                }
                case 7: {
                    return StringLib.sub(args);
                }
                case 8: {
                    return StringPacker.pack(args);
                }
                case 9: {
                    return StringPacker.unpack(args);
                }
            }
            return Constants.NONE;
        }
    }

    static final class StringLib1
    extends OneArgFunction {
        StringLib1() {
        }

        @Override
        public LuaValue call(LuaState state, LuaValue arg) throws LuaError {
            switch (this.opcode) {
                case 0: {
                    return ValueFactory.valueOf(arg.checkLuaString().length());
                }
                case 1: {
                    LuaString string = arg.checkLuaString();
                    if (string.length == 0) {
                        return Constants.EMPTYSTRING;
                    }
                    byte[] value = new byte[string.length];
                    System.arraycopy(string.bytes, string.offset, value, 0, value.length);
                    for (int i = 0; i < value.length; ++i) {
                        byte c = value[i];
                        if (c < 65 || c > 90) continue;
                        value[i] = (byte)(c | 0x20);
                    }
                    return ValueFactory.valueOf(value);
                }
                case 2: {
                    LuaString s = arg.checkLuaString();
                    int n = s.length();
                    byte[] b = new byte[n];
                    int i = 0;
                    int j = n - 1;
                    while (i < n) {
                        b[j] = (byte)s.luaByte(i);
                        ++i;
                        --j;
                    }
                    return LuaString.valueOf(b);
                }
                case 3: {
                    LuaString string = arg.checkLuaString();
                    if (string.length == 0) {
                        return Constants.EMPTYSTRING;
                    }
                    byte[] value = new byte[string.length];
                    System.arraycopy(string.bytes, string.offset, value, 0, value.length);
                    for (int i = 0; i < value.length; ++i) {
                        byte c = value[i];
                        if (c < 97 || c > 122) continue;
                        value[i] = (byte)(c & 0xFFFFFFDF);
                    }
                    return ValueFactory.valueOf(value);
                }
                case 4: {
                    return LuaInteger.valueOf(StringPacker.packsize(arg.checkLuaString()));
                }
            }
            return Constants.NIL;
        }
    }
}

